/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dmg.pmml.DataType;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.OpType;
import org.jpmml.evaluator.Computable;
import org.jpmml.evaluator.Evaluator;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;

public class EvaluatorUtil {
    private EvaluatorUtil() {
    }

    public static Object decode(Object object) {
        if (object instanceof Computable) {
            Computable computable = (Computable)object;
            return computable.getResult();
        }
        if (object instanceof Collection) {
            Collection rawValues = (Collection)object;
            Collection<Object> decodedValues = EvaluatorUtil.createCollection(rawValues);
            for (Object rawValue : rawValues) {
                decodedValues.add(EvaluatorUtil.decode(rawValue));
            }
            return decodedValues;
        }
        return object;
    }

    public static Map<String, ?> decode(Map<FieldName, ?> map) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        Set<Map.Entry<FieldName, ?>> entries = map.entrySet();
        for (Map.Entry entry : entries) {
            FieldName key = (FieldName)entry.getKey();
            Object value = entry.getValue();
            try {
                result.put(key != null ? key.getValue() : null, EvaluatorUtil.decode(value));
            }
            catch (UnsupportedOperationException ee) {}
        }
        return result;
    }

    public static FieldValue prepare(Evaluator evaluator, FieldName name, Object value) {
        if (value instanceof Collection) {
            Collection rawValues = (Collection)value;
            Collection<Object> preparedValues = EvaluatorUtil.createCollection(rawValues);
            DataType dataType = null;
            OpType opType = null;
            for (Object rawValue : rawValues) {
                FieldValue preparedValue = evaluator.prepare(name, rawValue);
                if (preparedValue != null) {
                    if (dataType == null) {
                        dataType = preparedValue.getDataType();
                    }
                    if (opType == null) {
                        opType = preparedValue.getOpType();
                    }
                }
                preparedValues.add(FieldValueUtil.getValue(preparedValue));
            }
            return FieldValueUtil.create(dataType, opType, preparedValues);
        }
        return evaluator.prepare(name, value);
    }

    /*
     * WARNING - void declaration
     */
    public static <K> List<Map<K, Object>> groupRows(K groupKey, List<? extends Map<K, ?>> table) {
        LinkedHashMap groupedRows = new LinkedHashMap();
        for (int i = 0; i < table.size(); ++i) {
            Map<K, ?> row = table.get(i);
            Object groupValue = row.get(groupKey);
            ListMultimap listMultimap = (ListMultimap)groupedRows.get(groupValue);
            if (listMultimap == null) {
                ArrayListMultimap arrayListMultimap = ArrayListMultimap.create();
                groupedRows.put(groupValue, arrayListMultimap);
            }
            Set<Map.Entry<K, ?>> entries = row.entrySet();
            for (Map.Entry entry : entries) {
                void var6_7;
                Object key = entry.getKey();
                Object value = entry.getValue();
                var6_7.put(key, value);
            }
        }
        ArrayList<Map<K, Object>> resultTable = new ArrayList<Map<K, Object>>();
        Set entries = groupedRows.entrySet();
        for (Map.Entry entry : entries) {
            LinkedHashMap resultRow = new LinkedHashMap();
            resultRow.putAll(((ListMultimap)entry.getValue()).asMap());
            resultRow.put(groupKey, entry.getKey());
            resultTable.add(resultRow);
        }
        return resultTable;
    }

    private static Collection<Object> createCollection(Collection<?> template) {
        if (template instanceof Set) {
            return new LinkedHashSet<Object>();
        }
        return new ArrayList<Object>();
    }
}

