/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.List;
import org.dmg.pmml.Apply;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.ParameterField;
import org.jpmml.evaluator.DefineFunctionEvaluationContext;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.ExpressionUtil;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.Function;
import org.jpmml.evaluator.FunctionException;
import org.jpmml.evaluator.FunctionRegistry;
import org.jpmml.evaluator.InvalidFeatureException;
import org.jpmml.evaluator.UnsupportedFeatureException;
import org.jpmml.model.ReflectionUtil;

public class FunctionUtil {
    private FunctionUtil() {
    }

    public static FieldValue evaluate(Apply apply, List<FieldValue> values, EvaluationContext context) {
        String name = apply.getFunction();
        Function function = FunctionRegistry.getFunction(name);
        if (function != null) {
            return function.evaluate(values);
        }
        EvaluationContext.Result<DefineFunction> result = context.resolveFunction(name);
        if (result != null) {
            return FunctionUtil.evaluate(result.getElement(), values, context);
        }
        throw new UnsupportedFeatureException((PMMLObject)apply, ReflectionUtil.getField((Object)apply, (String)"function"), name);
    }

    public static FieldValue evaluate(DefineFunction defineFunction, List<FieldValue> values, EvaluationContext context) {
        List parameterFields = defineFunction.getParameterFields();
        if (parameterFields.size() < 1) {
            throw new InvalidFeatureException((PMMLObject)defineFunction);
        }
        if (parameterFields.size() != values.size()) {
            throw new FunctionException(defineFunction.getName(), "Expected " + parameterFields.size() + " arguments, but got " + values.size() + " arguments");
        }
        DefineFunctionEvaluationContext functionContext = new DefineFunctionEvaluationContext(context);
        for (int i = 0; i < parameterFields.size(); ++i) {
            ParameterField parameterField = (ParameterField)parameterFields.get(i);
            FieldValue value = FieldValueUtil.refine((Field)parameterField, values.get(i));
            functionContext.declare(parameterField.getName(), value);
        }
        Expression expression = defineFunction.getExpression();
        if (expression == null) {
            throw new InvalidFeatureException((PMMLObject)defineFunction);
        }
        FieldValue result = ExpressionUtil.evaluate(expression, (EvaluationContext)functionContext);
        return FieldValueUtil.refine(defineFunction.getDataType(), defineFunction.getOpType(), result);
    }
}

