/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.concurrent.ConcurrentMap;
import javax.xml.bind.JAXBException;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.dmg.pmml.PMML;
import org.jpmml.evaluator.ModelEvaluator;
import org.jpmml.evaluator.ModelEvaluatorFactory;
import org.jpmml.model.ImportFilter;
import org.jpmml.model.JAXBUtil;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ModelEvaluatorCache {
    private ModelEvaluatorFactory modelEvaluatorFactory = null;
    private LoadingCache<URI, ModelEvaluator<?>> cache = null;

    public ModelEvaluatorCache(CacheBuilder<Object, Object> cacheBuilder) {
        this(ModelEvaluatorFactory.newInstance(), cacheBuilder);
    }

    public ModelEvaluatorCache(ModelEvaluatorFactory modelEvaluatorFactory, CacheBuilder<Object, Object> cacheBuilder) {
        this.setModelEvaluatorFactory(modelEvaluatorFactory);
        CacheLoader cacheLoader = new CacheLoader<URI, ModelEvaluator<?>>(){

            public ModelEvaluator<?> load(URI uri) throws Exception {
                return ModelEvaluatorCache.this.loadModelEvaluator(uri);
            }
        };
        this.cache = cacheBuilder.build(cacheLoader);
    }

    public ModelEvaluator<?> get(Class<?> clazz) throws Exception {
        return this.get(ModelEvaluatorCache.toURL(clazz));
    }

    public ModelEvaluator<?> get(URL url) throws Exception {
        URI uri = url.toURI();
        return (ModelEvaluator)this.cache.get((Object)uri);
    }

    public void remove(Class<?> clazz) throws Exception {
        this.remove(ModelEvaluatorCache.toURL(clazz));
    }

    public void remove(URL url) throws Exception {
        URI uri = url.toURI();
        this.cache.invalidate((Object)uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ModelEvaluator<?> loadModelEvaluator(URI uri) throws IOException, JAXBException, SAXException {
        PMML pmml;
        URL url = uri.toURL();
        try (InputStream is = url.openStream();){
            InputSource source = new InputSource(is);
            SAXSource transformedSource = ImportFilter.apply((InputSource)source);
            pmml = JAXBUtil.unmarshalPMML((Source)transformedSource);
        }
        pmml = this.process(pmml);
        ModelEvaluatorFactory modelEvaluatorFactory = this.getModelEvaluatorFactory();
        ModelEvaluator modelEvaluator = (ModelEvaluator)modelEvaluatorFactory.newModelManager(pmml);
        modelEvaluator.verify();
        return modelEvaluator;
    }

    protected PMML process(PMML pmml) {
        return pmml;
    }

    public ModelEvaluatorFactory getModelEvaluatorFactory() {
        return this.modelEvaluatorFactory;
    }

    private void setModelEvaluatorFactory(ModelEvaluatorFactory modelEvaluatorFactory) {
        this.modelEvaluatorFactory = modelEvaluatorFactory;
    }

    public ConcurrentMap<URI, ModelEvaluator<?>> asMap() {
        return this.cache.asMap();
    }

    private static URL toURL(Class<?> clazz) throws IOException {
        String path = clazz.getName().replace('.', '/') + ".pmml";
        ClassLoader clazzLoader = clazz.getClassLoader();
        URL url = clazzLoader.getResource(path);
        if (url == null) {
            throw new FileNotFoundException(path);
        }
        return url;
    }
}

