/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.HasName;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.TransformationDictionary;

public class PMMLManager
implements Serializable {
    private PMML pmml = null;

    public PMMLManager(PMML pmml) {
        this.setPMML((PMML)Preconditions.checkNotNull((Object)pmml));
    }

    public DataField getDataField(FieldName name) {
        DataDictionary dataDictionary = this.getDataDictionary();
        if (dataDictionary == null) {
            return null;
        }
        List dataFields = dataDictionary.getDataFields();
        return (DataField)PMMLManager.find(dataFields, name);
    }

    public DerivedField getDerivedField(FieldName name) {
        TransformationDictionary transformationDictionary = this.getTransformationDictionary();
        if (transformationDictionary == null) {
            return null;
        }
        List derivedFields = transformationDictionary.getDerivedFields();
        return (DerivedField)PMMLManager.find(derivedFields, name);
    }

    public DefineFunction getFunction(String name) {
        TransformationDictionary transformationDictionary = this.getTransformationDictionary();
        if (transformationDictionary == null) {
            return null;
        }
        List defineFunctions = transformationDictionary.getDefineFunctions();
        for (DefineFunction defineFunction : defineFunctions) {
            if (!defineFunction.getName().equals(name)) continue;
            return defineFunction;
        }
        return null;
    }

    public DataDictionary getDataDictionary() {
        PMML pmml = this.getPMML();
        return pmml.getDataDictionary();
    }

    public TransformationDictionary getTransformationDictionary() {
        PMML pmml = this.getPMML();
        return pmml.getTransformationDictionary();
    }

    public PMML getPMML() {
        return this.pmml;
    }

    private void setPMML(PMML pmml) {
        this.pmml = pmml;
    }

    public static <E extends PMMLObject> E find(Collection<E> objects, FieldName name) {
        for (PMMLObject object : objects) {
            if (!((HasName)object).getName().equals((Object)name)) continue;
            return (E)object;
        }
        return null;
    }
}

