/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.List;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.Interval;
import org.dmg.pmml.InvalidValueTreatmentMethodType;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.OpType;
import org.dmg.pmml.OutlierTreatmentMethodType;
import org.dmg.pmml.Value;
import org.jpmml.evaluator.ArgumentUtil;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.InvalidResultException;
import org.junit.Assert;
import org.junit.Test;

public class ArgumentUtilTest {
    @Test
    public void prepare() {
        FieldName name = new FieldName("x");
        DataField dataField = new DataField(name, OpType.CONTINUOUS, DataType.DOUBLE);
        MiningField miningField = new MiningField(name);
        Assert.assertEquals((Object)1.0, (Object)ArgumentUtilTest.prepare(dataField, miningField, "1"));
        Assert.assertEquals((Object)1.0, (Object)ArgumentUtilTest.prepare(dataField, miningField, 1));
        Assert.assertEquals((Object)1.0, (Object)ArgumentUtilTest.prepare(dataField, miningField, Float.valueOf(1.0f)));
        Assert.assertEquals((Object)1.0, (Object)ArgumentUtilTest.prepare(dataField, miningField, 1.0));
        Value missingValue = ArgumentUtilTest.createValue("N/A", Value.Property.MISSING);
        dataField.addValues(new Value[]{missingValue});
        Assert.assertEquals(null, (Object)ArgumentUtilTest.prepare(dataField, miningField, null));
        Assert.assertEquals(null, (Object)ArgumentUtilTest.prepare(dataField, miningField, "N/A"));
        miningField.setMissingValueReplacement("0");
        Assert.assertEquals((Object)0.0, (Object)ArgumentUtilTest.prepare(dataField, miningField, null));
        Assert.assertEquals((Object)0.0, (Object)ArgumentUtilTest.prepare(dataField, miningField, "N/A"));
        Interval validInterval = new Interval(Interval.Closure.CLOSED_CLOSED).setLeftMargin(Double.valueOf(1.0)).setRightMargin(Double.valueOf(3.0));
        dataField.addIntervals(new Interval[]{validInterval});
        miningField.setOutlierTreatment(OutlierTreatmentMethodType.AS_IS).setInvalidValueTreatment(InvalidValueTreatmentMethodType.AS_IS);
        Assert.assertEquals((Object)-1.0, (Object)ArgumentUtilTest.prepare(dataField, miningField, -1.0));
        Assert.assertEquals((Object)1.0, (Object)ArgumentUtilTest.prepare(dataField, miningField, 1.0));
        Assert.assertEquals((Object)5.0, (Object)ArgumentUtilTest.prepare(dataField, miningField, 5.0));
        miningField.setOutlierTreatment(OutlierTreatmentMethodType.AS_MISSING_VALUES).setInvalidValueTreatment(InvalidValueTreatmentMethodType.AS_IS);
        Assert.assertEquals((Object)0.0, (Object)ArgumentUtilTest.prepare(dataField, miningField, -1.0));
        Assert.assertEquals((Object)1.0, (Object)ArgumentUtilTest.prepare(dataField, miningField, 1.0));
        Assert.assertEquals((Object)0.0, (Object)ArgumentUtilTest.prepare(dataField, miningField, 5.0));
        miningField.setOutlierTreatment(OutlierTreatmentMethodType.AS_EXTREME_VALUES).setInvalidValueTreatment(InvalidValueTreatmentMethodType.AS_IS).setLowValue(Double.valueOf(1.0)).setHighValue(Double.valueOf(3.0));
        Assert.assertEquals((Object)1.0, (Object)ArgumentUtilTest.prepare(dataField, miningField, -1.0));
        Assert.assertEquals((Object)1.0, (Object)ArgumentUtilTest.prepare(dataField, miningField, 1.0));
        Assert.assertEquals((Object)3.0, (Object)ArgumentUtilTest.prepare(dataField, miningField, 5.0));
        miningField.setOutlierTreatment(OutlierTreatmentMethodType.AS_MISSING_VALUES).setInvalidValueTreatment(InvalidValueTreatmentMethodType.RETURN_INVALID).setLowValue(null).setHighValue(null);
        try {
            ArgumentUtilTest.prepare(dataField, miningField, -1.0);
            Assert.fail();
        }
        catch (InvalidResultException ire) {
            // empty catch block
        }
        Assert.assertEquals((Object)1.0, (Object)ArgumentUtilTest.prepare(dataField, miningField, 1.0));
        try {
            ArgumentUtilTest.prepare(dataField, miningField, 5.0);
            Assert.fail();
        }
        catch (InvalidResultException ire) {
            // empty catch block
        }
        miningField.setOutlierTreatment(OutlierTreatmentMethodType.AS_IS).setInvalidValueTreatment(InvalidValueTreatmentMethodType.AS_MISSING);
        Assert.assertEquals((Object)0.0, (Object)ArgumentUtilTest.prepare(dataField, miningField, -1.0));
        Assert.assertEquals((Object)1.0, (Object)ArgumentUtilTest.prepare(dataField, miningField, 1.0));
        Assert.assertEquals((Object)0.0, (Object)ArgumentUtilTest.prepare(dataField, miningField, 5.0));
        dataField = ArgumentUtilTest.clearIntervaldAndValues(dataField);
        dataField.addValues(new Value[]{missingValue, ArgumentUtilTest.createValue("1", Value.Property.VALID), ArgumentUtilTest.createValue("2", Value.Property.VALID), ArgumentUtilTest.createValue("3", Value.Property.VALID)});
        miningField.setInvalidValueTreatment(InvalidValueTreatmentMethodType.AS_IS);
        Assert.assertEquals((Object)1.0, (Object)ArgumentUtilTest.prepare(dataField, miningField, 1.0));
        Assert.assertEquals((Object)5.0, (Object)ArgumentUtilTest.prepare(dataField, miningField, 5.0));
        miningField.setInvalidValueTreatment(InvalidValueTreatmentMethodType.AS_MISSING);
        Assert.assertEquals((Object)1.0, (Object)ArgumentUtilTest.prepare(dataField, miningField, 1.0));
        Assert.assertEquals((Object)0.0, (Object)ArgumentUtilTest.prepare(dataField, miningField, 5.0));
        dataField = ArgumentUtilTest.clearIntervaldAndValues(dataField);
        dataField.addValues(new Value[]{missingValue, ArgumentUtilTest.createValue("1", Value.Property.INVALID)});
        miningField.setInvalidValueTreatment(InvalidValueTreatmentMethodType.AS_IS);
        Assert.assertEquals((Object)1.0, (Object)ArgumentUtilTest.prepare(dataField, miningField, 1.0));
        Assert.assertEquals((Object)5.0, (Object)ArgumentUtilTest.prepare(dataField, miningField, 5.0));
        miningField.setInvalidValueTreatment(InvalidValueTreatmentMethodType.AS_MISSING);
        Assert.assertEquals((Object)0.0, (Object)ArgumentUtilTest.prepare(dataField, miningField, 1.0));
        Assert.assertEquals((Object)5.0, (Object)ArgumentUtilTest.prepare(dataField, miningField, 5.0));
    }

    @Test
    public void isOutlier() {
        FieldName name = new FieldName("x");
        DataField dataField = new DataField(name, OpType.CONTINUOUS, DataType.DOUBLE).addIntervals(new Interval[]{ArgumentUtilTest.createInterval(Interval.Closure.CLOSED_CLOSED, -10.0, -1.0), ArgumentUtilTest.createInterval(Interval.Closure.CLOSED_CLOSED, 1.0, 10.0)});
        MiningField miningField = new MiningField(name);
        Assert.assertTrue((boolean)ArgumentUtil.isOutlier((DataField)dataField, (MiningField)miningField, (Object)-15.0));
        Assert.assertFalse((boolean)ArgumentUtil.isOutlier((DataField)dataField, (MiningField)miningField, (Object)0.0));
        Assert.assertTrue((boolean)ArgumentUtil.isOutlier((DataField)dataField, (MiningField)miningField, (Object)15.0));
    }

    @Test
    public void isInvalid() {
        Assert.assertFalse((boolean)ArgumentUtil.isInvalid(null, null, null));
    }

    @Test
    public void isValid() {
        Assert.assertFalse((boolean)ArgumentUtil.isValid(null, null, null));
    }

    private static Object prepare(DataField dataField, MiningField miningField, Object value) {
        FieldValue result = ArgumentUtil.prepare((DataField)dataField, (MiningField)miningField, (Object)value);
        return FieldValueUtil.getValue((FieldValue)result);
    }

    private static DataField clearIntervaldAndValues(DataField dataField) {
        List intervals = dataField.getIntervals();
        intervals.clear();
        List values = dataField.getValues();
        values.clear();
        return dataField;
    }

    private static Interval createInterval(Interval.Closure closure, Double leftMargin, Double rightMargin) {
        Interval result = new Interval(closure).setLeftMargin(leftMargin).setRightMargin(rightMargin);
        return result;
    }

    private static Value createValue(String value, Value.Property property) {
        Value result = new Value(value).setProperty(property);
        return result;
    }
}

