/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import org.dmg.pmml.ContinuousDistribution;
import org.dmg.pmml.GaussianDistribution;
import org.dmg.pmml.PoissonDistribution;
import org.jpmml.evaluator.DistributionUtil;
import org.junit.Assert;
import org.junit.Test;

public class DistributionUtilTest {
    @Test
    public void estimateDensity() {
        GaussianDistribution distribution = new GaussianDistribution(5.0, Math.pow(1.5, 2.0));
        Assert.assertEquals((double)0.00759732, (double)DistributionUtil.probability((ContinuousDistribution)distribution, (Number)1.0), (double)1.0E-6);
        Assert.assertEquals((double)0.10934005, (double)DistributionUtil.probability((ContinuousDistribution)distribution, (Number)3.0), (double)1.0E-6);
        Assert.assertEquals((double)0.26596152, (double)DistributionUtil.probability((ContinuousDistribution)distribution, (Number)5.0), (double)1.0E-6);
    }

    @Test
    public void estimateMass() {
        PoissonDistribution distribution = new PoissonDistribution(5.0);
        Assert.assertEquals((double)0.03368973, (double)DistributionUtil.probability((ContinuousDistribution)distribution, (Number)1), (double)1.0E-6);
        Assert.assertEquals((double)0.1403739, (double)DistributionUtil.probability((ContinuousDistribution)distribution, (Number)3), (double)1.0E-6);
        Assert.assertEquals((double)0.17546737, (double)DistributionUtil.probability((ContinuousDistribution)distribution, (Number)5), (double)1.0E-6);
        Assert.assertEquals((double)0.10444486, (double)DistributionUtil.probability((ContinuousDistribution)distribution, (Number)7), (double)1.0E-6);
        Assert.assertEquals((double)0.03626558, (double)DistributionUtil.probability((ContinuousDistribution)distribution, (Number)9), (double)1.0E-6);
    }
}

