/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.Arrays;
import java.util.List;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.Function;
import org.jpmml.evaluator.FunctionException;
import org.jpmml.evaluator.Functions;
import org.jpmml.evaluator.InvalidResultException;
import org.jpmml.evaluator.TypeCheckException;
import org.jpmml.evaluator.functions.EchoFunction;
import org.junit.Assert;
import org.junit.Test;

public class FunctionTest {
    @Test
    public void evaluateArithmeticFunctions() {
        FunctionTest.assertEquals(4.0, FunctionTest.evaluate((Function)Functions.PLUS, 1.0, 3.0));
        FunctionTest.assertEquals(-2.0, FunctionTest.evaluate((Function)Functions.MINUS, 1.0, 3.0));
        FunctionTest.assertEquals(3.0, FunctionTest.evaluate((Function)Functions.MULTIPLY, 1.0, 3.0));
        FunctionTest.assertEquals(0.3333333333333333, FunctionTest.evaluate((Function)Functions.DIVIDE, 1.0, 3.0));
        FunctionTest.assertEquals(null, FunctionTest.evaluate((Function)Functions.PLUS, 1.0, null));
        FunctionTest.assertEquals(null, FunctionTest.evaluate((Function)Functions.PLUS, null, 1.0));
        FunctionTest.assertEquals(1, FunctionTest.evaluate((Function)Functions.MULTIPLY, 1, 1));
        FunctionTest.assertEquals(Float.valueOf(1.0f), FunctionTest.evaluate((Function)Functions.MULTIPLY, Float.valueOf(1.0f), Float.valueOf(1.0f)));
        FunctionTest.assertEquals(1.0, FunctionTest.evaluate((Function)Functions.MULTIPLY, 1.0, 1.0));
        FunctionTest.assertEquals(1, FunctionTest.evaluate((Function)Functions.DIVIDE, 1, 1));
        FunctionTest.assertEquals(Float.valueOf(1.0f), FunctionTest.evaluate((Function)Functions.DIVIDE, 1, Float.valueOf(1.0f)));
        FunctionTest.assertEquals(Float.valueOf(1.0f), FunctionTest.evaluate((Function)Functions.DIVIDE, Float.valueOf(1.0f), Float.valueOf(1.0f)));
        FunctionTest.assertEquals(1.0, FunctionTest.evaluate((Function)Functions.DIVIDE, 1, 1.0));
        FunctionTest.assertEquals(1.0, FunctionTest.evaluate((Function)Functions.DIVIDE, Float.valueOf(1.0f), 1.0));
        FunctionTest.assertEquals(1.0, FunctionTest.evaluate((Function)Functions.DIVIDE, 1.0, 1.0));
    }

    @Test
    public void evaluateDivisionByZero() {
        try {
            FunctionTest.evaluate((Function)Functions.DIVIDE, 1, 0);
            Assert.fail();
        }
        catch (InvalidResultException invalidResultException) {
            // empty catch block
        }
        FunctionTest.assertEquals(Float.valueOf(Float.NEGATIVE_INFINITY), FunctionTest.evaluate((Function)Functions.DIVIDE, Float.valueOf(-1.0f), 0));
        FunctionTest.assertEquals(Float.valueOf(Float.POSITIVE_INFINITY), FunctionTest.evaluate((Function)Functions.DIVIDE, Float.valueOf(1.0f), 0));
        FunctionTest.assertEquals(Double.NEGATIVE_INFINITY, FunctionTest.evaluate((Function)Functions.DIVIDE, -1.0, 0));
        FunctionTest.assertEquals(Double.POSITIVE_INFINITY, FunctionTest.evaluate((Function)Functions.DIVIDE, 1.0, 0));
    }

    @Test
    public void evaluateAggregateFunctions() {
        List<Integer> values = Arrays.asList(1, 2, 3);
        FunctionTest.assertEquals(1, FunctionTest.evaluate((Function)Functions.MIN, values));
        FunctionTest.assertEquals(3, FunctionTest.evaluate((Function)Functions.MAX, values));
        FunctionTest.assertEquals(2.0, FunctionTest.evaluate((Function)Functions.AVG, values));
        FunctionTest.assertEquals(6, FunctionTest.evaluate((Function)Functions.SUM, values));
        FunctionTest.assertEquals(6, FunctionTest.evaluate((Function)Functions.PRODUCT, values));
    }

    @Test
    public void evaluateMathFunctions() {
        FunctionTest.assertEquals(0.0, FunctionTest.evaluate((Function)Functions.LOG10, 1));
        FunctionTest.assertEquals(Float.valueOf(0.0f), FunctionTest.evaluate((Function)Functions.LOG10, Float.valueOf(1.0f)));
        FunctionTest.assertEquals(0.0, FunctionTest.evaluate((Function)Functions.LN, 1));
        FunctionTest.assertEquals(Float.valueOf(0.0f), FunctionTest.evaluate((Function)Functions.LN, Float.valueOf(1.0f)));
        FunctionTest.assertEquals(1.0, FunctionTest.evaluate((Function)Functions.EXP, 0));
        FunctionTest.assertEquals(Float.valueOf(1.0f), FunctionTest.evaluate((Function)Functions.EXP, Float.valueOf(0.0f)));
        FunctionTest.assertEquals(1.0, FunctionTest.evaluate((Function)Functions.SQRT, 1));
        FunctionTest.assertEquals(Float.valueOf(1.0f), FunctionTest.evaluate((Function)Functions.SQRT, Float.valueOf(1.0f)));
        FunctionTest.assertEquals(1, FunctionTest.evaluate((Function)Functions.ABS, -1));
        FunctionTest.assertEquals(Float.valueOf(1.0f), FunctionTest.evaluate((Function)Functions.ABS, Float.valueOf(-1.0f)));
        FunctionTest.assertEquals(1.0, FunctionTest.evaluate((Function)Functions.ABS, -1.0));
        FunctionTest.assertEquals(1, FunctionTest.evaluate((Function)Functions.POW, 1, 1));
        FunctionTest.assertEquals(Float.valueOf(1.0f), FunctionTest.evaluate((Function)Functions.POW, Float.valueOf(1.0f), Float.valueOf(1.0f)));
        FunctionTest.assertEquals(0, FunctionTest.evaluate((Function)Functions.THRESHOLD, 2, 3));
        FunctionTest.assertEquals(0, FunctionTest.evaluate((Function)Functions.THRESHOLD, 3, 3));
        FunctionTest.assertEquals(1, FunctionTest.evaluate((Function)Functions.THRESHOLD, 3, 2));
        FunctionTest.assertEquals(Float.valueOf(0.0f), FunctionTest.evaluate((Function)Functions.THRESHOLD, Float.valueOf(2.0f), Float.valueOf(3.0f)));
        FunctionTest.assertEquals(Float.valueOf(0.0f), FunctionTest.evaluate((Function)Functions.THRESHOLD, Float.valueOf(3.0f), Float.valueOf(3.0f)));
        FunctionTest.assertEquals(Float.valueOf(1.0f), FunctionTest.evaluate((Function)Functions.THRESHOLD, Float.valueOf(3.0f), Float.valueOf(2.0f)));
        FunctionTest.assertEquals(1, FunctionTest.evaluate((Function)Functions.FLOOR, 1));
        FunctionTest.assertEquals(1, FunctionTest.evaluate((Function)Functions.CEIL, 1));
        FunctionTest.assertEquals(Float.valueOf(1.0f), FunctionTest.evaluate((Function)Functions.FLOOR, Float.valueOf(1.99f)));
        FunctionTest.assertEquals(Float.valueOf(2.0f), FunctionTest.evaluate((Function)Functions.ROUND, Float.valueOf(1.99f)));
        FunctionTest.assertEquals(Float.valueOf(1.0f), FunctionTest.evaluate((Function)Functions.CEIL, Float.valueOf(0.01f)));
        FunctionTest.assertEquals(Float.valueOf(0.0f), FunctionTest.evaluate((Function)Functions.ROUND, Float.valueOf(0.01f)));
    }

    @Test
    public void evaluateValueFunctions() {
        FunctionTest.assertEquals(true, FunctionTest.evaluate((Function)Functions.IS_MISSING, new Object[]{null}));
        FunctionTest.assertEquals(false, FunctionTest.evaluate((Function)Functions.IS_MISSING, "value"));
        FunctionTest.assertEquals(true, FunctionTest.evaluate((Function)Functions.IS_NOT_MISSING, "value"));
        FunctionTest.assertEquals(false, FunctionTest.evaluate((Function)Functions.IS_NOT_MISSING, new Object[]{null}));
    }

    @Test
    public void evaluateEqualityFunctions() {
        FunctionTest.assertEquals(true, FunctionTest.evaluate((Function)Functions.EQUAL, 1, 1.0));
        FunctionTest.assertEquals(true, FunctionTest.evaluate((Function)Functions.EQUAL, 1.0, 1.0));
        FunctionTest.assertEquals(true, FunctionTest.evaluate((Function)Functions.NOT_EQUAL, 1.0, 3.0));
        FunctionTest.assertEquals(true, FunctionTest.evaluate((Function)Functions.NOT_EQUAL, 1, 3));
    }

    @Test
    public void evaluateComparisonFunctions() {
        FunctionTest.assertEquals(true, FunctionTest.evaluate((Function)Functions.LESS_THAN, 1.0, 3.0));
        FunctionTest.assertEquals(true, FunctionTest.evaluate((Function)Functions.LESS_THAN, 1, 3.0));
        FunctionTest.assertEquals(true, FunctionTest.evaluate((Function)Functions.LESS_OR_EQUAL, 1.0, 1.0));
        FunctionTest.assertEquals(true, FunctionTest.evaluate((Function)Functions.LESS_OR_EQUAL, 1, 1.0));
        FunctionTest.assertEquals(true, FunctionTest.evaluate((Function)Functions.GREATER_THAN, 3.0, 1.0));
        FunctionTest.assertEquals(true, FunctionTest.evaluate((Function)Functions.GREATER_THAN, 3, 1.0));
        FunctionTest.assertEquals(true, FunctionTest.evaluate((Function)Functions.GREATER_OR_EQUAL, 3.0, 3.0));
        FunctionTest.assertEquals(true, FunctionTest.evaluate((Function)Functions.GREATER_OR_EQUAL, 3, 3.0));
    }

    @Test
    public void evaluateBooleanComparisonFunctions() {
        try {
            FunctionTest.evaluate((Function)Functions.LESS_OR_EQUAL, false, "false");
            Assert.fail();
        }
        catch (TypeCheckException tce) {
            // empty catch block
        }
        FunctionTest.assertEquals(true, FunctionTest.evaluate((Function)Functions.LESS_THAN, false, 0.5));
        FunctionTest.assertEquals(false, FunctionTest.evaluate((Function)Functions.LESS_THAN, true, 0.5));
        FunctionTest.assertEquals(true, FunctionTest.evaluate((Function)Functions.LESS_OR_EQUAL, false, 0.0));
        FunctionTest.assertEquals(false, FunctionTest.evaluate((Function)Functions.LESS_OR_EQUAL, true, 0.0));
        FunctionTest.assertEquals(false, FunctionTest.evaluate((Function)Functions.GREATER_THAN, false, 0.5));
        FunctionTest.assertEquals(true, FunctionTest.evaluate((Function)Functions.GREATER_THAN, true, 0.5));
        FunctionTest.assertEquals(false, FunctionTest.evaluate((Function)Functions.GREATER_OR_EQUAL, false, 1.0));
        FunctionTest.assertEquals(true, FunctionTest.evaluate((Function)Functions.GREATER_OR_EQUAL, true, 1.0));
        try {
            FunctionTest.evaluate((Function)Functions.LESS_OR_EQUAL, false, false);
            Assert.fail();
        }
        catch (TypeCheckException typeCheckException) {
            // empty catch block
        }
    }

    @Test
    public void evaluateBinaryFunctions() {
        FunctionTest.assertEquals(true, FunctionTest.evaluate((Function)Functions.AND, true, true));
        FunctionTest.assertEquals(true, FunctionTest.evaluate((Function)Functions.AND, true, true, true));
        FunctionTest.assertEquals(false, FunctionTest.evaluate((Function)Functions.AND, true, false));
        FunctionTest.assertEquals(false, FunctionTest.evaluate((Function)Functions.AND, false, true));
        FunctionTest.assertEquals(true, FunctionTest.evaluate((Function)Functions.OR, false, true));
        FunctionTest.assertEquals(true, FunctionTest.evaluate((Function)Functions.OR, false, false, true));
        FunctionTest.assertEquals(false, FunctionTest.evaluate((Function)Functions.OR, false, false));
    }

    @Test
    public void evaluateUnaryFunction() {
        FunctionTest.assertEquals(true, FunctionTest.evaluate((Function)Functions.NOT, false));
        FunctionTest.assertEquals(false, FunctionTest.evaluate((Function)Functions.NOT, true));
    }

    @Test
    public void evaluateValueListFunctions() {
        FunctionTest.assertEquals(true, FunctionTest.evaluate((Function)Functions.IS_IN, "3", "1", "2", "3"));
        FunctionTest.assertEquals(true, FunctionTest.evaluate((Function)Functions.IS_NOT_IN, "0", "1", "2", "3"));
        FunctionTest.assertEquals(true, FunctionTest.evaluate((Function)Functions.IS_IN, 3, 1, 2, 3));
        FunctionTest.assertEquals(true, FunctionTest.evaluate((Function)Functions.IS_NOT_IN, 0, 1, 2, 3));
        FunctionTest.assertEquals(true, FunctionTest.evaluate((Function)Functions.IS_IN, 3.0, 1.0, 2.0, 3.0));
        FunctionTest.assertEquals(true, FunctionTest.evaluate((Function)Functions.IS_NOT_IN, 0.0, 1.0, 2.0, 3.0));
    }

    @Test
    public void evaluateIfFunction() {
        FunctionTest.assertEquals("left", FunctionTest.evaluate((Function)Functions.IF, true, "left"));
        FunctionTest.assertEquals("left", FunctionTest.evaluate((Function)Functions.IF, true, "left", "right"));
        FunctionTest.assertEquals(null, FunctionTest.evaluate((Function)Functions.IF, false, "left"));
        FunctionTest.assertEquals("right", FunctionTest.evaluate((Function)Functions.IF, false, "left", "right"));
    }

    @Test
    public void evaluateStringFunctions() {
        FunctionTest.assertEquals("VALUE", FunctionTest.evaluate((Function)Functions.UPPERCASE, "Value"));
        FunctionTest.assertEquals("value", FunctionTest.evaluate((Function)Functions.LOWERCASE, "Value"));
        FunctionTest.assertEquals("", FunctionTest.evaluate((Function)Functions.SUBSTRING, "value", 1, 0));
        FunctionTest.assertEquals("value", FunctionTest.evaluate((Function)Functions.SUBSTRING, "value", 1, 5));
        FunctionTest.assertEquals("alue", FunctionTest.evaluate((Function)Functions.SUBSTRING, "value", 2, 4));
        FunctionTest.assertEquals("valu", FunctionTest.evaluate((Function)Functions.SUBSTRING, "value", 1, 4));
        FunctionTest.assertEquals("value", FunctionTest.evaluate((Function)Functions.TRIM_BLANKS, "\tvalue\t"));
    }

    @Test
    public void evaluateConcatenationFunction() {
        FunctionTest.assertEquals("2-2000", FunctionTest.evaluate((Function)Functions.CONCAT, "2", "-", "2000"));
        FunctionTest.assertEquals("2-2000", FunctionTest.evaluate((Function)Functions.CONCAT, "2", null, "-", null, "2000"));
        FunctionTest.assertEquals("2-2000", FunctionTest.evaluate((Function)Functions.CONCAT, 2, "-", 2000));
    }

    @Test
    public void evaluateRegularExpressionFunctions() {
        FunctionTest.assertEquals("c", FunctionTest.evaluate((Function)Functions.REPLACE, "BBBB", "B+", "c"));
        FunctionTest.assertEquals("cccc", FunctionTest.evaluate((Function)Functions.REPLACE, "BBBB", "B+?", "c"));
        FunctionTest.assertEquals("a*cada*", FunctionTest.evaluate((Function)Functions.REPLACE, "abracadabra", "bra", "*"));
        FunctionTest.assertEquals("*", FunctionTest.evaluate((Function)Functions.REPLACE, "abracadabra", "a.*a", "*"));
        FunctionTest.assertEquals("*c*bra", FunctionTest.evaluate((Function)Functions.REPLACE, "abracadabra", "a.*?a", "*"));
        FunctionTest.assertEquals("brcdbr", FunctionTest.evaluate((Function)Functions.REPLACE, "abracadabra", "a", ""));
        FunctionTest.assertEquals("abbraccaddabbra", FunctionTest.evaluate((Function)Functions.REPLACE, "abracadabra", "a(.)", "a$1$1"));
        String[] monthNames = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
        for (int i = 0; i < monthNames.length; ++i) {
            boolean matches = i == 0 || i == 1 || i == 4;
            FunctionTest.assertEquals(matches, FunctionTest.evaluate((Function)Functions.MATCHES, monthNames[i], "ar?y"));
        }
        FunctionTest.assertEquals(true, FunctionTest.evaluate((Function)Functions.MATCHES, "abracadabra", "bra"));
        FunctionTest.assertEquals(true, FunctionTest.evaluate((Function)Functions.MATCHES, "abracadabra", "^a.*a$"));
        FunctionTest.assertEquals(false, FunctionTest.evaluate((Function)Functions.MATCHES, "abracadabra", "^bra"));
    }

    @Test
    public void evaluateFormatFunctions() {
        FunctionTest.assertEquals("  2", FunctionTest.evaluate((Function)Functions.FORMAT_NUMBER, 2, "%3d"));
        FunctionTest.assertEquals("08/20/04", FunctionTest.evaluate((Function)Functions.FORMAT_DATETIME, new LocalDate(2004, 8, 20), "%m/%d/%y"));
    }

    @Test
    public void evaluateDateTimeFunctions() {
        FunctionTest.assertEquals(15796, FunctionTest.evaluate((Function)Functions.DATE_DAYS_SINCE_YEAR, new LocalDate(2003, 4, 1), 1960));
        FunctionTest.assertEquals(15796, FunctionTest.evaluate((Function)Functions.DATE_DAYS_SINCE_YEAR, new LocalDateTime(2003, 4, 1, 0, 0, 0), 1960));
        FunctionTest.assertEquals(19410, FunctionTest.evaluate((Function)Functions.DATE_SECONDS_SINCE_MIDNIGHT, new LocalTime(5, 23, 30)));
        FunctionTest.assertEquals(19410, FunctionTest.evaluate((Function)Functions.DATE_SECONDS_SINCE_MIDNIGHT, new LocalDateTime(1960, 1, 1, 5, 23, 30)));
        FunctionTest.assertEquals(185403, FunctionTest.evaluate((Function)Functions.DATE_SECONDS_SINCE_YEAR, new LocalDateTime(1960, 1, 3, 3, 30, 3), 1960));
    }

    @Test
    public void evaluateEchoFunction() {
        EchoFunction function = new EchoFunction();
        try {
            FunctionTest.evaluate((Function)function, new Object[0]);
            Assert.fail();
        }
        catch (FunctionException fe) {
            // empty catch block
        }
        FunctionTest.assertEquals("Hello World!", FunctionTest.evaluate((Function)function, "Hello World!"));
        try {
            FunctionTest.evaluate((Function)function, "Hello World!", "Hello World!");
            Assert.fail();
        }
        catch (FunctionException functionException) {
            // empty catch block
        }
    }

    private static void assertEquals(Object expected, FieldValue actual) {
        Assert.assertEquals((Object)FieldValueUtil.create((Object)expected), (Object)actual);
    }

    private static FieldValue evaluate(Function function, Object ... arguments) {
        return FunctionTest.evaluate(function, Arrays.asList(arguments));
    }

    private static FieldValue evaluate(Function function, List<?> arguments) {
        return function.evaluate(FieldValueUtil.createAll(arguments));
    }
}

