/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMML;
import org.jpmml.evaluator.Computable;
import org.jpmml.evaluator.EvaluatorUtil;
import org.jpmml.evaluator.HasEntityId;
import org.jpmml.evaluator.HasProbability;
import org.jpmml.evaluator.MiningModelEvaluator;
import org.jpmml.evaluator.ModelEvaluator;
import org.jpmml.evaluator.ModelEvaluatorFactory;
import org.jpmml.evaluator.ModelEvaluatorTest;
import org.jpmml.evaluator.TreeModelEvaluator;
import org.junit.Assert;
import org.junit.Test;

public class SelectAllTest
extends ModelEvaluatorTest {
    @Test
    public void evaluate() throws Exception {
        CountingModelEvaluatorFactory evaluatorFactory = new CountingModelEvaluatorFactory();
        ModelEvaluator<?> evaluator = this.createModelEvaluator(evaluatorFactory);
        Map<FieldName, ?> arguments = SelectAllTest.createArguments("sepal_length", 5.1, "sepal_width", 3.5, "petal_length", 1.4, "petal_width", 0.2);
        Map result = evaluator.evaluate(arguments);
        Assert.assertEquals((long)1L, (long)evaluatorFactory.getMiningModelCount());
        Assert.assertEquals((long)5L, (long)evaluatorFactory.getTreeModelCount());
        Assert.assertEquals((long)1L, (long)result.size());
        Collection species = (Collection)result.get(new FieldName("species"));
        Assert.assertEquals((long)5L, (long)species.size());
        for (Object value : species) {
            Assert.assertTrue((boolean)(value instanceof Computable & value instanceof HasEntityId & value instanceof HasProbability));
        }
        Assert.assertEquals(Arrays.asList("setosa", "setosa", "setosa", "setosa", "versicolor"), (Object)EvaluatorUtil.decode((Object)species));
    }

    private static class CountingModelEvaluatorFactory
    extends ModelEvaluatorFactory {
        private int miningModelCount = 0;
        private int treeModelCount = 0;

        private CountingModelEvaluatorFactory() {
        }

        public ModelEvaluator<? extends Model> newModelManager(PMML pmml, Model model) {
            ModelEvaluator result = super.newModelManager(pmml, model);
            if (result instanceof MiningModelEvaluator) {
                ++this.miningModelCount;
            } else if (result instanceof TreeModelEvaluator) {
                ++this.treeModelCount;
            } else {
                throw new AssertionError();
            }
            return result;
        }

        public int getMiningModelCount() {
            return this.miningModelCount;
        }

        public int getTreeModelCount() {
            return this.treeModelCount;
        }
    }
}

