/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.lang.reflect.Field;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.OpType;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Value;
import org.jpmml.evaluator.XPathUtil;
import org.junit.Assert;
import org.junit.Test;

public class XPathUtilTest {
    @Test
    public void formatXPath() throws Exception {
        DataField dataField = new DataField(new FieldName("x"), OpType.CATEGORICAL, DataType.DOUBLE).addValues(new Value[]{new Value("0"), new Value("1")});
        Assert.assertEquals((Object)"DataField", (Object)XPathUtil.formatXPath((PMMLObject)dataField));
        Field valuesField = DataField.class.getDeclaredField("values");
        Assert.assertEquals((Object)"DataField/Value", (Object)XPathUtil.formatXPath((PMMLObject)dataField, (Field)valuesField));
        Field isCyclicField = DataField.class.getDeclaredField("cyclic");
        Assert.assertEquals((Object)"DataField@isCyclic", (Object)XPathUtil.formatXPath((PMMLObject)dataField, (Field)isCyclicField));
        Assert.assertEquals((Object)"DataField@isCyclic", (Object)XPathUtil.formatXPath((PMMLObject)dataField, (Field)isCyclicField, null));
        Assert.assertEquals((Object)"DataField@isCyclic=0", (Object)XPathUtil.formatXPath((PMMLObject)dataField, (Field)isCyclicField, (Object)"0"));
    }
}

