/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.visitors;

import org.dmg.pmml.Array;
import org.dmg.pmml.False;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.Node;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.SimplePredicate;
import org.dmg.pmml.SimpleSetPredicate;
import org.dmg.pmml.True;
import org.dmg.pmml.Visitable;
import org.jpmml.evaluator.visitors.PredicateInterner;
import org.junit.Assert;
import org.junit.Test;

public class PredicateInternerTest {
    @Test
    public void internSimplePredicate() {
        Node left = new Node().setPredicate((Predicate)new SimplePredicate(new FieldName("x"), SimplePredicate.Operator.EQUAL).setValue("1"));
        Node right = new Node().setPredicate((Predicate)new SimplePredicate(new FieldName("x"), SimplePredicate.Operator.EQUAL).setValue("1"));
        PredicateInternerTest.checkTree(left, right);
    }

    @Test
    public void internSimpleSetPredicate() {
        Node left = new Node().setPredicate((Predicate)new SimpleSetPredicate(new FieldName("x"), SimpleSetPredicate.BooleanOperator.IS_IN, new Array(Array.Type.STRING, "1")));
        Node right = new Node().setPredicate((Predicate)new SimpleSetPredicate(new FieldName("x"), SimpleSetPredicate.BooleanOperator.IS_IN, new Array(Array.Type.STRING, "\"1\"")));
        PredicateInternerTest.checkTree(left, right);
    }

    @Test
    public void internTrue() {
        Node left = new Node().setPredicate((Predicate)new True());
        Node right = new Node().setPredicate((Predicate)new True());
        PredicateInternerTest.checkTree(left, right);
    }

    @Test
    public void internFalse() {
        Node left = new Node().setPredicate((Predicate)new False());
        Node right = new Node().setPredicate((Predicate)new False());
        PredicateInternerTest.checkTree(left, right);
    }

    private static void checkTree(Node left, Node right) {
        Node root = new Node().addNodes(new Node[]{left, right});
        Assert.assertNotSame((Object)left.getPredicate(), (Object)right.getPredicate());
        PredicateInterner interner = new PredicateInterner();
        interner.applyTo((Visitable)root);
        Assert.assertSame((Object)left.getPredicate(), (Object)right.getPredicate());
    }
}

