/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.base.Function;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.dmg.pmml.Array;
import org.dmg.pmml.PMMLObject;
import org.jpmml.evaluator.CacheUtil;
import org.jpmml.evaluator.InvalidFeatureException;
import org.jpmml.evaluator.TypeCheckException;
import org.jpmml.evaluator.UnsupportedFeatureException;

public class ArrayUtil {
    private static Interner<String> tokenInterner = Interners.newWeakInterner();
    private static final LoadingCache<Array, List<String>> contentCache = CacheBuilder.newBuilder().weakKeys().build((CacheLoader)new CacheLoader<Array, List<String>>(){

        public List<String> load(Array array) {
            return ImmutableList.copyOf(ArrayUtil.parse(array));
        }
    });

    private ArrayUtil() {
    }

    public static int getSize(Array array) {
        Integer n = array.getN();
        if (n != null) {
            return n;
        }
        List<String> context = ArrayUtil.getContent(array);
        return context.size();
    }

    public static List<String> getContent(Array array) {
        return CacheUtil.getValue(array, contentCache);
    }

    public static double[] toArray(Array array) {
        int size = ArrayUtil.getSize(array);
        double[] result = new double[size];
        List<? extends Number> content = ArrayUtil.getNumberContent(array);
        for (int i = 0; i < size; ++i) {
            Number value = content.get(i);
            result[i] = value.doubleValue();
        }
        return result;
    }

    public static List<? extends Number> getNumberContent(Array array) {
        Array.Type type = array.getType();
        switch (type) {
            case INT: {
                return ArrayUtil.getIntContent(array);
            }
            case REAL: {
                return ArrayUtil.getRealContent(array);
            }
        }
        throw new TypeCheckException(Number.class, null);
    }

    public static List<Integer> getIntContent(Array array) {
        Function<String, Integer> transformer = new Function<String, Integer>(){

            public Integer apply(String string) {
                return Integer.valueOf(string);
            }
        };
        return Lists.transform(ArrayUtil.getContent(array), (Function)transformer);
    }

    public static List<Double> getRealContent(Array array) {
        Function<String, Double> transformer = new Function<String, Double>(){

            public Double apply(String string) {
                return Double.valueOf(string);
            }
        };
        return Lists.transform(ArrayUtil.getContent(array), (Function)transformer);
    }

    public static List<String> parse(Array array) {
        List<String> result;
        Array.Type type = array.getType();
        switch (type) {
            case INT: 
            case REAL: {
                result = ArrayUtil.tokenize(array.getValue(), false);
                break;
            }
            case STRING: {
                result = ArrayUtil.tokenize(array.getValue(), true);
                break;
            }
            default: {
                throw new UnsupportedFeatureException((PMMLObject)array, (Enum<?>)type);
            }
        }
        Integer n = array.getN();
        if (n != null && n.intValue() != result.size()) {
            throw new InvalidFeatureException((PMMLObject)array);
        }
        return result;
    }

    public static List<String> tokenize(String string, boolean enableQuotes) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        boolean quoted = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (quoted) {
                if (c == '\\' && i < string.length() - 1) {
                    c = string.charAt(i + 1);
                    if (c == '\"') {
                        sb.append('\"');
                        ++i;
                        continue;
                    }
                    sb.append('\\');
                    continue;
                }
                sb.append(c);
                if (c != '\"') continue;
                result.add(ArrayUtil.createToken(sb, enableQuotes));
                quoted = false;
                continue;
            }
            if (c == '\"' && enableQuotes) {
                if (sb.length() > 0) {
                    result.add(ArrayUtil.createToken(sb, enableQuotes));
                }
                sb.append('\"');
                quoted = true;
                continue;
            }
            if (Character.isWhitespace(c)) {
                if (sb.length() <= 0) continue;
                result.add(ArrayUtil.createToken(sb, enableQuotes));
                continue;
            }
            sb.append(c);
        }
        if (sb.length() > 0) {
            result.add(ArrayUtil.createToken(sb, enableQuotes));
        }
        return result;
    }

    private static String createToken(StringBuilder sb, boolean enableQuotes) {
        String result = sb.length() > 1 && sb.charAt(0) == '\"' && sb.charAt(sb.length() - 1) == '\"' && enableQuotes ? sb.substring(1, sb.length() - 1) : sb.substring(0, sb.length());
        result = (String)tokenInterner.intern((Object)result);
        sb.setLength(0);
        return result;
    }
}

