/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.LinkedHashMap;
import java.util.Map;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.Function;
import org.jpmml.evaluator.Functions;

public class FunctionRegistry {
    private static final Map<String, Function> functions = new LinkedHashMap<String, Function>();

    private FunctionRegistry() {
    }

    public static Function getFunction(String name) {
        Function function = functions.get(name);
        if (function == null) {
            function = FunctionRegistry.loadJavaFunction(name);
        }
        return function;
    }

    public static void putFunctions(Function ... functions) {
        for (Function function : functions) {
            FunctionRegistry.putFunction(function);
        }
    }

    public static void putFunction(Function function) {
        FunctionRegistry.putFunction(function.getName(), function);
    }

    public static void putFunction(String name, Function function) {
        functions.put(name, function);
    }

    private static Function loadJavaFunction(String name) {
        Function function;
        Class<?> clazz;
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                classLoader = FunctionRegistry.class.getClassLoader();
            }
            clazz = classLoader.loadClass(name);
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
        if (!Function.class.isAssignableFrom(clazz)) {
            return null;
        }
        try {
            function = (Function)clazz.newInstance();
        }
        catch (Exception e) {
            throw new EvaluationException();
        }
        return function;
    }

    static {
        FunctionRegistry.putFunctions(Functions.PLUS, Functions.MINUS, Functions.MULTIPLY, Functions.DIVIDE);
        FunctionRegistry.putFunctions(Functions.MIN, Functions.MAX, Functions.AVG, Functions.SUM, Functions.PRODUCT);
        FunctionRegistry.putFunctions(Functions.LOG10, Functions.LN, Functions.EXP, Functions.SQRT, Functions.ABS, Functions.POW, Functions.THRESHOLD, Functions.FLOOR, Functions.CEIL, Functions.ROUND);
        FunctionRegistry.putFunctions(Functions.IS_MISSING, Functions.IS_NOT_MISSING);
        FunctionRegistry.putFunctions(Functions.EQUAL, Functions.NOT_EQUAL);
        FunctionRegistry.putFunctions(Functions.LESS_THAN, Functions.LESS_OR_EQUAL, Functions.GREATER_THAN, Functions.GREATER_OR_EQUAL);
        FunctionRegistry.putFunctions(Functions.AND, Functions.OR);
        FunctionRegistry.putFunctions(Functions.NOT);
        FunctionRegistry.putFunctions(Functions.IS_IN, Functions.IS_NOT_IN);
        FunctionRegistry.putFunctions(Functions.IF);
        FunctionRegistry.putFunctions(Functions.UPPERCASE, Functions.LOWERCASE, Functions.SUBSTRING, Functions.TRIM_BLANKS);
        FunctionRegistry.putFunctions(Functions.CONCAT);
        FunctionRegistry.putFunctions(Functions.REPLACE, Functions.MATCHES);
        FunctionRegistry.putFunctions(Functions.FORMAT_NUMBER, Functions.FORMAT_DATETIME);
        FunctionRegistry.putFunctions(Functions.DATE_DAYS_SINCE_YEAR, Functions.DATE_SECONDS_SINCE_MIDNIGHT, Functions.DATE_SECONDS_SINCE_YEAR);
    }
}

