/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import org.dmg.pmml.DataField;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldName;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.PMMLManager;

public class PMMLEvaluationContext
extends EvaluationContext {
    private PMMLManager pmmlManager = null;

    public PMMLEvaluationContext(PMMLManager pmmlManager) {
        this.setPmmlManager(pmmlManager);
    }

    @Override
    public EvaluationContext.Result<DerivedField> resolveDerivedField(FieldName name) {
        PMMLManager pmmlManager = this.getPmmlManager();
        DerivedField derivedField = pmmlManager.getDerivedField(name);
        return this.createResult(derivedField);
    }

    @Override
    public EvaluationContext.Result<DefineFunction> resolveFunction(String name) {
        PMMLManager pmmlManager = this.getPmmlManager();
        DefineFunction defineFunction = pmmlManager.getFunction(name);
        return this.createResult(defineFunction);
    }

    @Override
    public FieldValue createFieldValue(FieldName name, Object value) {
        PMMLManager pmmlManager = this.getPmmlManager();
        DataField dataField = pmmlManager.getDataField(name);
        if (dataField != null) {
            return FieldValueUtil.create((Field)dataField, value);
        }
        return super.createFieldValue(name, value);
    }

    public PMMLManager getPmmlManager() {
        return this.pmmlManager;
    }

    private void setPmmlManager(PMMLManager pmmlManager) {
        this.pmmlManager = pmmlManager;
    }
}

