/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.base.Function;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jpmml.evaluator.ClassificationAggregator;
import org.jpmml.evaluator.HasProbability;
import org.jpmml.evaluator.RegressionAggregator;

class ProbabilityAggregator
extends ClassificationAggregator<String> {
    ProbabilityAggregator() {
    }

    public void add(HasProbability hasProbability) {
        this.add(hasProbability, 1.0);
    }

    public void add(HasProbability hasProbability, double weight) {
        Set<String> categories = hasProbability.getCategoryValues();
        for (String category : categories) {
            Double probability = hasProbability.getProbability(category);
            this.add(category, (Double)(probability * weight));
        }
    }

    public Map<String, Double> maxMap() {
        Function<List<Double>, Double> function = new Function<List<Double>, Double>(){

            public Double apply(List<Double> values) {
                return Collections.max(values);
            }
        };
        return this.transform(function);
    }

    public Map<String, Double> medianMap() {
        Function<List<Double>, Double> function = new Function<List<Double>, Double>(){

            public Double apply(List<Double> values) {
                return RegressionAggregator.median(values);
            }
        };
        return this.transform(function);
    }

    public Map<String, Double> averageMap(final double denominator) {
        Function<List<Double>, Double> function = new Function<List<Double>, Double>(){

            public Double apply(List<Double> values) {
                return RegressionAggregator.sum(values) / denominator;
            }
        };
        return this.transform(function);
    }
}

