/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.Attribute;
import org.dmg.pmml.Characteristic;
import org.dmg.pmml.Characteristics;
import org.dmg.pmml.ComplexPartialScore;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.MiningFunctionType;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Scorecard;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.ExpressionUtil;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.InvalidFeatureException;
import org.jpmml.evaluator.InvalidResultException;
import org.jpmml.evaluator.ModelEvaluationContext;
import org.jpmml.evaluator.ModelEvaluator;
import org.jpmml.evaluator.OutputUtil;
import org.jpmml.evaluator.PredicateUtil;
import org.jpmml.evaluator.ReasonCodeRanking;
import org.jpmml.evaluator.TargetUtil;
import org.jpmml.evaluator.UnsupportedFeatureException;
import org.jpmml.evaluator.VoteAggregator;

public class ScorecardEvaluator
extends ModelEvaluator<Scorecard> {
    public ScorecardEvaluator(PMML pmml) {
        super(pmml, Scorecard.class);
    }

    public ScorecardEvaluator(PMML pmml, Scorecard scorecard) {
        super(pmml, scorecard);
    }

    @Override
    public String getSummary() {
        return "Scorecard";
    }

    @Override
    public Map<FieldName, ?> evaluate(ModelEvaluationContext context) {
        Map<FieldName, ?> predictions;
        Scorecard scorecard = (Scorecard)this.getModel();
        if (!scorecard.isScorable()) {
            throw new InvalidResultException((PMMLObject)scorecard);
        }
        MiningFunctionType miningFunction = scorecard.getFunctionName();
        switch (miningFunction) {
            case REGRESSION: {
                predictions = this.evaluateRegression(context);
                break;
            }
            default: {
                throw new UnsupportedFeatureException((PMMLObject)scorecard, (Enum<?>)miningFunction);
            }
        }
        return OutputUtil.evaluate(predictions, context);
    }

    private Map<FieldName, ?> evaluateRegression(ModelEvaluationContext context) {
        Scorecard scorecard = (Scorecard)this.getModel();
        double score = scorecard.getInitialScore();
        boolean useReasonCodes = scorecard.isUseReasonCodes();
        VoteAggregator<String> reasonCodePoints = new VoteAggregator<String>();
        Characteristics characteristics = scorecard.getCharacteristics();
        for (Characteristic characteristic : characteristics) {
            Double baselineScore = characteristic.getBaselineScore();
            if (baselineScore == null) {
                baselineScore = scorecard.getBaselineScore();
            }
            if (useReasonCodes && baselineScore == null) {
                throw new InvalidFeatureException((PMMLObject)characteristic);
            }
            boolean hasTrueAttribute = false;
            List attributes = characteristic.getAttributes();
            for (Attribute attribute : attributes) {
                org.dmg.pmml.Predicate predicate = attribute.getPredicate();
                if (predicate == null) {
                    throw new InvalidFeatureException((PMMLObject)attribute);
                }
                Boolean status = PredicateUtil.evaluate(predicate, context);
                if (status == null || !status.booleanValue()) continue;
                Double partialScore = null;
                ComplexPartialScore complexPartialScore = attribute.getComplexPartialScore();
                if (complexPartialScore != null) {
                    Expression expression = complexPartialScore.getExpression();
                    if (expression == null) {
                        throw new InvalidFeatureException((PMMLObject)complexPartialScore);
                    }
                    FieldValue computedValue = ExpressionUtil.evaluate(expression, (EvaluationContext)context);
                    if (computedValue == null) {
                        return TargetUtil.evaluateRegressionDefault(context);
                    }
                    partialScore = computedValue.asNumber().doubleValue();
                } else {
                    partialScore = attribute.getPartialScore();
                }
                if (partialScore == null) {
                    throw new InvalidFeatureException((PMMLObject)attribute);
                }
                score += partialScore.doubleValue();
                String reasonCode = attribute.getReasonCode();
                if (reasonCode == null) {
                    reasonCode = characteristic.getReasonCode();
                }
                if (useReasonCodes) {
                    Double difference;
                    if (reasonCode == null) {
                        throw new InvalidFeatureException((PMMLObject)attribute);
                    }
                    Scorecard.ReasonCodeAlgorithm reasonCodeAlgorithm = scorecard.getReasonCodeAlgorithm();
                    switch (reasonCodeAlgorithm) {
                        case POINTS_ABOVE: {
                            difference = partialScore - baselineScore;
                            break;
                        }
                        case POINTS_BELOW: {
                            difference = baselineScore - partialScore;
                            break;
                        }
                        default: {
                            throw new UnsupportedFeatureException((PMMLObject)scorecard, (Enum<?>)reasonCodeAlgorithm);
                        }
                    }
                    reasonCodePoints.add(reasonCode, difference);
                }
                hasTrueAttribute = true;
                break;
            }
            if (hasTrueAttribute) continue;
            throw new InvalidResultException((PMMLObject)characteristic);
        }
        Map<FieldName, ?> result = TargetUtil.evaluateRegression(score, context);
        if (useReasonCodes) {
            Map.Entry resultEntry = (Map.Entry)Iterables.getOnlyElement(result.entrySet());
            return Collections.singletonMap(resultEntry.getKey(), ScorecardEvaluator.createReasonCodeList(reasonCodePoints.sumMap(), resultEntry.getValue()));
        }
        return result;
    }

    private static ReasonCodeRanking createReasonCodeList(Map<String, Double> reasonCodes, Object value) {
        Predicate<Map.Entry<String, Double>> predicate = new Predicate<Map.Entry<String, Double>>(){

            public boolean apply(Map.Entry<String, Double> entry) {
                return Double.compare(entry.getValue(), 0.0) >= 0;
            }
        };
        Map meaningfulReasonCodes = Maps.filterEntries(reasonCodes, (Predicate)predicate);
        ReasonCodeRanking result = new ReasonCodeRanking(value, meaningfulReasonCodes);
        return result;
    }
}

