/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import org.dmg.pmml.DataType;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.TypeUtil;

public class TypeCheckException
extends EvaluationException {
    public TypeCheckException(DataType expected, FieldValue value) {
        this(expected, FieldValueUtil.getValue(value));
    }

    public TypeCheckException(DataType expected, Object value) {
        super(TypeCheckException.formatMessage(expected, value != null ? TypeUtil.getDataType(value) : null, value));
    }

    public TypeCheckException(Class<?> expected, FieldValue value) {
        this(expected, FieldValueUtil.getValue(value));
    }

    public TypeCheckException(Class<?> expected, Object value) {
        super(TypeCheckException.formatMessage(expected, value != null ? value.getClass() : null, value));
    }

    private static String formatMessage(DataType expected, DataType actual, Object value) {
        String message = "Expected " + expected + ", but got " + (actual != null ? actual : "null");
        if (value != null) {
            message = message + " (" + String.valueOf(value) + ")";
        }
        return message;
    }

    private static String formatMessage(Class<?> expected, Class<?> actual, Object value) {
        String message = "Expected " + expected.getName() + ", but got " + (actual != null ? actual.getName() : "null");
        if (value != null) {
            message = message + " (" + String.valueOf(value) + ")";
        }
        return message;
    }
}

