/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.Map;
import org.dmg.pmml.FieldName;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.PMMLEvaluationContext;
import org.jpmml.evaluator.PMMLManager;
import org.jpmml.evaluator.PMMLManagerTest;
import org.junit.Assert;
import org.junit.Test;

public class PMMLEvaluationContextTest
extends PMMLManagerTest {
    @Test
    public void evaluateAmPm() throws Exception {
        PMMLEvaluationContextTest.assertValueEquals("AM", this.evaluate(FieldName.create((String)"Shift"), PMMLEvaluationContextTest.createArguments("StartTime", 34742)));
    }

    @Test
    public void evaluateStategroup() throws Exception {
        PMMLEvaluationContextTest.assertValueEquals("West", this.evaluate(FieldName.create((String)"Group"), PMMLEvaluationContextTest.createArguments("State", "CA")));
    }

    @Test
    public void evaluateSimpleTable() throws Exception {
        FieldName name = FieldName.create((String)"SimpleTable");
        PMMLEvaluationContextTest.assertValueEquals(null, this.evaluate(name, PMMLEvaluationContextTest.createArguments("Value", null)));
        PMMLEvaluationContextTest.assertValueEquals("first", this.evaluate(name, PMMLEvaluationContextTest.createArguments("Value", 1)));
        PMMLEvaluationContextTest.assertValueEquals("second", this.evaluate(name, PMMLEvaluationContextTest.createArguments("Value", 2)));
        PMMLEvaluationContextTest.assertValueEquals(null, this.evaluate(name, PMMLEvaluationContextTest.createArguments("Value", 3)));
    }

    @Test
    public void evaluateComplexTable() throws Exception {
        FieldName name = FieldName.create((String)"ComplexTable");
        PMMLEvaluationContextTest.assertValueEquals(null, this.evaluate(name, PMMLEvaluationContextTest.createArguments("Value", null, "Modifier", null)));
        PMMLEvaluationContextTest.assertValueEquals("firstTrue", this.evaluate(name, PMMLEvaluationContextTest.createArguments("Value", 1, "Modifier", true)));
        PMMLEvaluationContextTest.assertValueEquals("firstFalse", this.evaluate(name, PMMLEvaluationContextTest.createArguments("Value", 1, "Modifier", false)));
        PMMLEvaluationContextTest.assertValueEquals("secondTrue", this.evaluate(name, PMMLEvaluationContextTest.createArguments("Value", 2, "Modifier", true)));
        PMMLEvaluationContextTest.assertValueEquals("secondFalse", this.evaluate(name, PMMLEvaluationContextTest.createArguments("Value", 2, "Modifier", false)));
        PMMLEvaluationContextTest.assertValueEquals(null, this.evaluate(name, PMMLEvaluationContextTest.createArguments("Value", 3, "Modifier", null)));
        PMMLEvaluationContextTest.assertValueEquals(null, this.evaluate(name, PMMLEvaluationContextTest.createArguments("Value", 3, "Modifier", true)));
    }

    private FieldValue evaluate(FieldName name, Map<FieldName, ?> arguments) throws Exception {
        PMMLManager pmmlManager = this.createPMMLManager();
        PMMLEvaluationContext context = new PMMLEvaluationContext(pmmlManager);
        context.declareAll(arguments);
        return context.evaluate(name);
    }

    private static void assertValueEquals(Object expected, FieldValue actual) {
        Assert.assertEquals((Object)expected, (Object)FieldValueUtil.getValue((FieldValue)actual));
    }
}

