/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.Aggregate;
import org.dmg.pmml.Apply;
import org.dmg.pmml.Constant;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Discretize;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldColumnPair;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.InvalidValueTreatmentMethodType;
import org.dmg.pmml.MapValues;
import org.dmg.pmml.NormContinuous;
import org.dmg.pmml.NormDiscrete;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.ExpressionUtil;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.FunctionException;
import org.jpmml.evaluator.InvalidResultException;
import org.jpmml.evaluator.PMMLManagerTest;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.VirtualEvaluationContext;
import org.jpmml.evaluator.functions.EchoFunction;
import org.junit.Assert;
import org.junit.Test;

public class ExpressionUtilTest {
    @Test
    public void evaluateConstant() {
        Constant constant = new Constant("3");
        Assert.assertEquals((Object)DataType.INTEGER, (Object)ExpressionUtilTest.getDataType((Expression)constant));
        Assert.assertEquals((Object)3, (Object)ExpressionUtilTest.evaluate((Expression)constant, new Object[0]));
        Constant stringThree = new Constant("3").setDataType(DataType.STRING);
        Assert.assertEquals((Object)DataType.STRING, (Object)ExpressionUtilTest.getDataType((Expression)stringThree));
        Assert.assertEquals((Object)"3", (Object)ExpressionUtilTest.evaluate((Expression)stringThree, new Object[0]));
        Constant integerThree = new Constant("3").setDataType(DataType.INTEGER);
        Assert.assertEquals((Object)3, (Object)ExpressionUtilTest.evaluate((Expression)integerThree, new Object[0]));
        Constant floatThree = new Constant("3").setDataType(DataType.FLOAT);
        Assert.assertEquals((Object)Float.valueOf(3.0f), (Object)ExpressionUtilTest.evaluate((Expression)floatThree, new Object[0]));
    }

    @Test
    public void evaluateFieldRef() {
        FieldName name = FieldName.create((String)"x");
        FieldRef fieldRef = new FieldRef(name);
        Assert.assertEquals((Object)"3", (Object)ExpressionUtilTest.evaluate((Expression)fieldRef, name, "3"));
        Assert.assertEquals(null, (Object)ExpressionUtilTest.evaluate((Expression)fieldRef, name, null));
        fieldRef.setMapMissingTo("Missing");
        Assert.assertEquals((Object)"Missing", (Object)ExpressionUtilTest.evaluate((Expression)fieldRef, name, null));
    }

    @Test
    public void evaluateNormContinuous() {
        FieldName name = FieldName.create((String)"x");
        NormContinuous normContinuous = new NormContinuous(name, null).setMapMissingTo(Double.valueOf(5.0));
        Assert.assertEquals((Object)DataType.DOUBLE, (Object)ExpressionUtilTest.getDataType((Expression)normContinuous));
        Assert.assertEquals((Object)5.0, (Object)ExpressionUtilTest.evaluate((Expression)normContinuous, name, null));
    }

    @Test
    public void evaluateNormDiscrete() {
        FieldName name = FieldName.create((String)"x");
        Double equals = 1.0;
        Double notEquals = 0.0;
        NormDiscrete stringThree = new NormDiscrete(name, "3");
        Assert.assertEquals((Object)DataType.DOUBLE, (Object)ExpressionUtilTest.getDataType((Expression)stringThree));
        Assert.assertEquals((Object)equals, (Object)ExpressionUtilTest.evaluate((Expression)stringThree, name, "3"));
        Assert.assertEquals((Object)notEquals, (Object)ExpressionUtilTest.evaluate((Expression)stringThree, name, "1"));
        stringThree.setMapMissingTo(Double.valueOf(5.0));
        Assert.assertEquals((Object)5.0, (Object)ExpressionUtilTest.evaluate((Expression)stringThree, name, null));
        NormDiscrete integerThree = new NormDiscrete(name, "3");
        Assert.assertEquals((Object)equals, (Object)ExpressionUtilTest.evaluate((Expression)integerThree, name, 3));
        Assert.assertEquals((Object)notEquals, (Object)ExpressionUtilTest.evaluate((Expression)integerThree, name, 1));
        NormDiscrete floatThree = new NormDiscrete(name, "3.0");
        Assert.assertEquals((Object)equals, (Object)ExpressionUtilTest.evaluate((Expression)floatThree, name, Float.valueOf(3.0f)));
        Assert.assertEquals((Object)notEquals, (Object)ExpressionUtilTest.evaluate((Expression)floatThree, name, Float.valueOf(1.0f)));
    }

    @Test
    public void evaluateDiscretize() {
        FieldName name = FieldName.create((String)"x");
        Discretize discretize = new Discretize(name);
        Assert.assertEquals((Object)DataType.STRING, (Object)ExpressionUtilTest.getDataType((Expression)discretize));
        Assert.assertEquals(null, (Object)ExpressionUtilTest.evaluate((Expression)discretize, name, null));
        discretize.setMapMissingTo("Missing");
        Assert.assertEquals((Object)"Missing", (Object)ExpressionUtilTest.evaluate((Expression)discretize, name, null));
        Assert.assertEquals(null, (Object)ExpressionUtilTest.evaluate((Expression)discretize, name, 3));
        discretize.setDefaultValue("Default");
        Assert.assertEquals((Object)"Default", (Object)ExpressionUtilTest.evaluate((Expression)discretize, name, 3));
    }

    @Test
    public void evaluateMapValues() {
        FieldName name = FieldName.create((String)"x");
        MapValues mapValues = new MapValues(null).addFieldColumnPairs(new FieldColumnPair[]{new FieldColumnPair(name, null)});
        Assert.assertEquals((Object)DataType.STRING, (Object)ExpressionUtilTest.getDataType((Expression)mapValues));
        Assert.assertEquals(null, (Object)ExpressionUtilTest.evaluate((Expression)mapValues, name, null));
        mapValues.setMapMissingTo("Missing");
        Assert.assertEquals((Object)"Missing", (Object)ExpressionUtilTest.evaluate((Expression)mapValues, name, null));
        Assert.assertEquals(null, (Object)ExpressionUtilTest.evaluate((Expression)mapValues, name, "3"));
        mapValues.setDefaultValue("Default");
        Assert.assertEquals((Object)"Default", (Object)ExpressionUtilTest.evaluate((Expression)mapValues, name, "3"));
    }

    @Test
    public void evaluateApply() {
        FieldName name = FieldName.create((String)"x");
        Apply apply = new Apply("/").addExpressions(new Expression[]{new FieldRef(name), new Constant("0")});
        Assert.assertEquals(null, (Object)ExpressionUtilTest.evaluate((Expression)apply, name, null));
        apply.setDefaultValue("-1");
        Assert.assertEquals((Object)"-1", (Object)ExpressionUtilTest.evaluate((Expression)apply, name, null));
        apply.setMapMissingTo("missing");
        Assert.assertEquals((Object)"missing", (Object)ExpressionUtilTest.evaluate((Expression)apply, name, null));
        apply.setInvalidValueTreatment(InvalidValueTreatmentMethodType.RETURN_INVALID);
        try {
            ExpressionUtilTest.evaluate((Expression)apply, name, 1);
            Assert.fail();
        }
        catch (InvalidResultException ire) {
            // empty catch block
        }
        apply.setInvalidValueTreatment(InvalidValueTreatmentMethodType.AS_IS);
        try {
            ExpressionUtilTest.evaluate((Expression)apply, name, 1);
            Assert.fail();
        }
        catch (InvalidResultException invalidResultException) {
            // empty catch block
        }
        apply.setInvalidValueTreatment(InvalidValueTreatmentMethodType.AS_MISSING);
        Assert.assertEquals((Object)"-1", (Object)ExpressionUtilTest.evaluate((Expression)apply, name, 1));
    }

    @Test
    public void evaluateApplyCondition() {
        FieldName name = FieldName.create((String)"x");
        Apply condition = new Apply("isNotMissing").addExpressions(new Expression[]{new FieldRef(name)});
        Apply apply = new Apply("if").addExpressions(new Expression[]{condition});
        try {
            ExpressionUtilTest.evaluate((Expression)apply, name, null);
            Assert.fail();
        }
        catch (FunctionException fe) {
            // empty catch block
        }
        Apply thenPart = new Apply("abs").addExpressions(new Expression[]{new FieldRef(name)});
        apply.addExpressions(new Expression[]{thenPart});
        Assert.assertEquals((Object)1, (Object)ExpressionUtilTest.evaluate((Expression)apply, name, 1));
        Assert.assertEquals((Object)1, (Object)ExpressionUtilTest.evaluate((Expression)apply, name, -1));
        Assert.assertEquals(null, (Object)ExpressionUtilTest.evaluate((Expression)apply, name, null));
        Constant elsePart = new Constant("-1").setDataType(DataType.DOUBLE);
        apply.addExpressions(new Expression[]{elsePart});
        Assert.assertEquals((Object)-1.0, (Object)ExpressionUtilTest.evaluate((Expression)apply, name, null));
        apply.addExpressions(new Expression[]{new FieldRef(name)});
        try {
            ExpressionUtilTest.evaluate((Expression)apply, name, null);
            Assert.fail();
        }
        catch (FunctionException fe) {
            // empty catch block
        }
    }

    @Test
    public void evaluateApplyJavaFunction() {
        FieldName name = FieldName.create((String)"x");
        FieldRef fieldRef = new FieldRef(name);
        Apply apply = new Apply(EchoFunction.class.getName()).addExpressions(new Expression[]{fieldRef});
        try {
            ExpressionUtilTest.evaluate((Expression)apply, new Object[0]);
            Assert.fail();
        }
        catch (EvaluationException ee) {
            Assert.assertEquals((Object)fieldRef, (Object)ee.getContext());
        }
        Assert.assertEquals((Object)"Hello World!", (Object)ExpressionUtilTest.evaluate((Expression)apply, name, "Hello World!"));
    }

    @Test
    public void evaluateAggregateArithmetic() {
        FieldName name = FieldName.create((String)"x");
        List<Integer> values = Arrays.asList(1, 2, 3);
        Aggregate aggregate = new Aggregate(name, Aggregate.Function.COUNT);
        Assert.assertEquals((Object)3, (Object)ExpressionUtilTest.evaluate((Expression)aggregate, name, values));
        aggregate.setFunction(Aggregate.Function.SUM);
        Assert.assertEquals((Object)6, (Object)ExpressionUtilTest.evaluate((Expression)aggregate, name, values));
        aggregate.setFunction(Aggregate.Function.AVERAGE);
        Assert.assertEquals((Object)2.0, (Object)ExpressionUtilTest.evaluate((Expression)aggregate, name, values));
    }

    @Test
    public void evaluateAggregate() {
        FieldName name = FieldName.create((String)"x");
        List<Object> values = Arrays.asList(TypeUtil.parse((DataType)DataType.DATE, (String)"2013-01-01"), TypeUtil.parse((DataType)DataType.DATE, (String)"2013-02-01"), TypeUtil.parse((DataType)DataType.DATE, (String)"2013-03-01"));
        Aggregate aggregate = new Aggregate(name, Aggregate.Function.COUNT);
        Assert.assertEquals((Object)3, (Object)ExpressionUtilTest.evaluate((Expression)aggregate, name, values));
        aggregate.setFunction(Aggregate.Function.MIN);
        Assert.assertEquals((Object)values.get(0), (Object)ExpressionUtilTest.evaluate((Expression)aggregate, name, values));
        aggregate.setFunction(Aggregate.Function.MAX);
        Assert.assertEquals((Object)values.get(2), (Object)ExpressionUtilTest.evaluate((Expression)aggregate, name, values));
    }

    private static Object evaluate(Expression expression, Object ... objects) {
        Map<FieldName, ?> arguments = PMMLManagerTest.createArguments(objects);
        return ExpressionUtilTest.evaluate(expression, arguments);
    }

    private static Object evaluate(Expression expression, Map<FieldName, ?> arguments) {
        VirtualEvaluationContext context = new VirtualEvaluationContext();
        context.declareAll(arguments);
        FieldValue result = ExpressionUtil.evaluate((Expression)expression, (EvaluationContext)context);
        return FieldValueUtil.getValue((FieldValue)result);
    }

    private static DataType getDataType(Expression expression) {
        return ExpressionUtil.getDataType((Expression)expression, null);
    }
}

