/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.Map;
import org.jpmml.evaluator.HasProbability;
import org.jpmml.evaluator.ProbabilityAggregator;
import org.jpmml.evaluator.ProbabilityDistribution;
import org.junit.Assert;
import org.junit.Test;

public class ProbabilityAggregatorTest {
    @Test
    public void add() {
        ProbabilityAggregator aggregator = new ProbabilityAggregator();
        aggregator.add(ProbabilityAggregatorTest.createProbabilityDistribution(1.0, 3.0));
        Map maxMap = aggregator.maxMap();
        Assert.assertEquals((Object)1.0, maxMap.get("A"));
        Assert.assertEquals((Object)3.0, maxMap.get("B"));
        aggregator.add(ProbabilityAggregatorTest.createProbabilityDistribution(3.0, 1.0), 0.5);
        maxMap = aggregator.maxMap();
        Assert.assertEquals((Object)1.5, maxMap.get("A"));
        Assert.assertEquals((Object)3.0, maxMap.get("B"));
        double denominator = 1.5;
        Map averageMap = aggregator.averageMap(denominator);
        double sumA = 2.5;
        double sumB = 3.5;
        Assert.assertEquals((Object)(sumA / denominator), averageMap.get("A"));
        Assert.assertEquals((Object)(sumB / denominator), averageMap.get("B"));
        Assert.assertEquals((long)2L, (long)aggregator.size());
    }

    private static HasProbability createProbabilityDistribution(Double a, Double b) {
        ProbabilityDistribution result = new ProbabilityDistribution();
        result.put("A", a);
        result.put("B", b);
        return result;
    }
}

