/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.base.Equivalence;
import com.google.common.base.Function;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dmg.pmml.FieldName;
import org.jpmml.evaluator.Batch;
import org.jpmml.evaluator.Conflict;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.Evaluator;
import org.jpmml.evaluator.EvaluatorUtil;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.VerificationUtil;

public class BatchUtil {
    private BatchUtil() {
    }

    public static List<Conflict> evaluate(Batch batch, Set<FieldName> ignoredFields, final double precision, final double zeroThreshold) throws Exception {
        Evaluator evaluator = batch.getEvaluator();
        List<Map<FieldName, Object>> input = batch.getInput();
        List<Map<FieldName, ?>> output = batch.getOutput();
        List<FieldName> groupFields = evaluator.getGroupFields();
        List<FieldName> targetFields = evaluator.getTargetFields();
        if (groupFields.size() == 1) {
            FieldName groupField = groupFields.get(0);
            input = EvaluatorUtil.groupRows(groupField, input);
        } else if (groupFields.size() > 1) {
            throw new EvaluationException();
        }
        Equivalence<Object> equivalence = new Equivalence<Object>(){

            public boolean doEquivalent(Object expected, Object actual) {
                actual = EvaluatorUtil.decode(actual);
                return VerificationUtil.acceptable(TypeUtil.parseOrCast(TypeUtil.getDataType(actual), expected), actual, precision, zeroThreshold);
            }

            public int doHash(Object object) {
                return object.hashCode();
            }
        };
        if (output.size() > 0) {
            if (input.size() != output.size()) {
                throw new EvaluationException();
            }
            ArrayList<Conflict> conflicts = new ArrayList<Conflict>();
            for (int i = 0; i < input.size(); ++i) {
                MapDifference difference;
                Map<FieldName, Object> arguments = input.get(i);
                Map<FieldName, ?> result = evaluator.evaluate(arguments);
                if (targetFields.size() == 0) {
                    result = new LinkedHashMap(result);
                    result.remove(evaluator.getTargetField());
                }
                if (ignoredFields != null && ignoredFields.size() > 0) {
                    result = new LinkedHashMap(result);
                    Set<FieldName> fields = result.keySet();
                    fields.removeAll(ignoredFields);
                }
                if ((difference = Maps.difference(output.get(i), result, (Equivalence)equivalence)).areEqual()) continue;
                Conflict conflict = new Conflict(i, arguments, difference);
                conflicts.add(conflict);
            }
            return conflicts;
        }
        for (int i = 0; i < input.size(); ++i) {
            Map<FieldName, Object> arguments = input.get(i);
            evaluator.evaluate(arguments);
        }
        return Collections.emptyList();
    }

    public static Object evaluateDefault(Batch batch) throws Exception {
        Evaluator evaluator = batch.getEvaluator();
        Map arguments = Collections.emptyMap();
        Map<FieldName, ?> result = evaluator.evaluate(arguments);
        return result.get(evaluator.getTargetField());
    }

    public static List<Map<FieldName, String>> parseRecords(List<List<String>> table, Function<String, String> function) {
        ArrayList<Map<FieldName, String>> records = new ArrayList<Map<FieldName, String>>(table.size() - 1);
        List<String> headerRow = table.get(0);
        LinkedHashSet<String> uniqueHeaderRow = new LinkedHashSet<String>(headerRow);
        if (uniqueHeaderRow.size() < headerRow.size()) {
            ArrayList<String> duplicateCells = new ArrayList<String>();
            for (int j = 0; j < headerRow.size(); ++j) {
                String cell = headerRow.get(j);
                if (Collections.frequency(headerRow, cell) == 1) continue;
                duplicateCells.add(cell);
            }
            throw new IllegalArgumentException("Expected unique cell names, but got non-unique cell name(s) " + duplicateCells);
        }
        for (int i = 1; i < table.size(); ++i) {
            List<String> bodyRow = table.get(i);
            if (headerRow.size() != bodyRow.size()) {
                throw new IllegalArgumentException("Expected " + headerRow.size() + " cells, but got " + bodyRow.size() + " cells (data record " + (i - 1) + ")");
            }
            LinkedHashMap<FieldName, Object> record = new LinkedHashMap<FieldName, Object>();
            for (int j = 0; j < headerRow.size(); ++j) {
                record.put(FieldName.create((String)headerRow.get(j)), function.apply((Object)bodyRow.get(j)));
            }
            records.add(record);
        }
        return records;
    }

    public static List<List<String>> formatRecords(List<Map<FieldName, ?>> records, List<FieldName> names, Function<Object, String> function) {
        ArrayList<List<String>> table = new ArrayList<List<String>>(1 + records.size());
        ArrayList<String> headerRow = new ArrayList<String>(names.size());
        for (FieldName fieldName : names) {
            headerRow.add(fieldName.getValue());
        }
        table.add(headerRow);
        for (Map map : records) {
            ArrayList<Object> bodyRow = new ArrayList<Object>(names.size());
            for (FieldName name : names) {
                bodyRow.add(function.apply(map.get(name)));
            }
            table.add(bodyRow);
        }
        return table;
    }
}

