/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheBuilderSpec;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.dmg.pmml.PMMLObject;
import org.jpmml.evaluator.InvalidFeatureException;
import org.jpmml.evaluator.PMMLException;

public class CacheUtil {
    private static CacheBuilderSpec cacheBuilderSpec = CacheBuilderSpec.parse((String)"weakKeys");

    private CacheUtil() {
    }

    public static <K extends PMMLObject, V> V getValue(K key, LoadingCache<K, V> cache) {
        try {
            return (V)cache.get(key);
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof PMMLException) {
                throw (PMMLException)cause;
            }
            throw (PMMLException)new InvalidFeatureException(key).initCause(cause);
        }
    }

    public static <K extends PMMLObject, V> V getValue(K key, Cache<K, V> cache, Callable<? extends V> loader) {
        try {
            return (V)cache.get(key, loader);
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof PMMLException) {
                throw (PMMLException)cause;
            }
            throw (PMMLException)new InvalidFeatureException(key).initCause(cause);
        }
    }

    public static <K extends PMMLObject, V> Cache<K, V> buildCache() {
        CacheBuilder<Object, Object> cacheBuilder = CacheUtil.newCacheBuilder();
        return cacheBuilder.build();
    }

    public static <K extends PMMLObject, V> LoadingCache<K, V> buildLoadingCache(CacheLoader<K, V> cacheLoader) {
        CacheBuilder<Object, Object> cacheBuilder = CacheUtil.newCacheBuilder();
        return cacheBuilder.build(cacheLoader);
    }

    private static CacheBuilder<Object, Object> newCacheBuilder() {
        CacheBuilder cacheBuilder = CacheBuilder.from((CacheBuilderSpec)cacheBuilderSpec);
        return cacheBuilder;
    }

    public static CacheBuilderSpec getCacheBuilderSpec() {
        return cacheBuilderSpec;
    }

    public static void setCacheBuilderSpec(CacheBuilderSpec cacheBuilderSpec) {
        if (cacheBuilderSpec == null) {
            throw new NullPointerException();
        }
        CacheUtil.cacheBuilderSpec = cacheBuilderSpec;
    }
}

