/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import org.joda.time.Days;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.joda.time.base.BaseSingleFieldPeriod;
import org.jpmml.evaluator.ComplexPeriod;

public class DaysSinceDate
extends ComplexPeriod<DaysSinceDate> {
    private Days days = null;

    public DaysSinceDate(int year, LocalDate date) {
        this(new LocalDate(year, 1, 1), date);
    }

    public DaysSinceDate(LocalDate epoch, LocalDate date) {
        this(epoch, Days.daysBetween((ReadablePartial)epoch, (ReadablePartial)date));
    }

    public DaysSinceDate(LocalDate epoch, Days days) {
        super(epoch);
        this.setDays(days);
    }

    @Override
    public int intValue() {
        return this.getDays().getDays();
    }

    @Override
    public int compareTo(DaysSinceDate that) {
        if (!this.getEpoch().equals((Object)that.getEpoch())) {
            throw new ClassCastException();
        }
        return this.getDays().compareTo((BaseSingleFieldPeriod)that.getDays());
    }

    public int hashCode() {
        return 31 * this.getEpoch().hashCode() + this.getDays().hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof DaysSinceDate) {
            DaysSinceDate that = (DaysSinceDate)object;
            return this.getEpoch().equals((Object)that.getEpoch()) && this.getDays().equals((Object)that.getDays());
        }
        return false;
    }

    public Days getDays() {
        return this.days;
    }

    private void setDays(Days days) {
        this.days = days;
    }
}

