/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableRangeMap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Table;
import com.google.common.collect.TreeRangeMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Discretize;
import org.dmg.pmml.DiscretizeBin;
import org.dmg.pmml.InlineTable;
import org.dmg.pmml.Interval;
import org.dmg.pmml.MapValues;
import org.dmg.pmml.OpType;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.TableLocator;
import org.jpmml.evaluator.CacheUtil;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.HasParsedValueMapping;
import org.jpmml.evaluator.InlineTableUtil;
import org.jpmml.evaluator.InvalidFeatureException;
import org.jpmml.evaluator.UnsupportedFeatureException;

public class DiscretizationUtil {
    private static final LoadingCache<Discretize, RangeMap<Double, String>> binRangeCache = CacheUtil.buildLoadingCache(new CacheLoader<Discretize, RangeMap<Double, String>>(){

        public RangeMap<Double, String> load(Discretize discretize) {
            return ImmutableRangeMap.copyOf((RangeMap)DiscretizationUtil.parseDiscretize(discretize));
        }
    });
    private static final LoadingCache<InlineTable, Map<String, RowFilter>> rowFilterCache = CacheUtil.buildLoadingCache(new CacheLoader<InlineTable, Map<String, RowFilter>>(){

        public Map<String, RowFilter> load(InlineTable inlineTable) {
            return ImmutableMap.copyOf((Map)DiscretizationUtil.parseInlineTable(inlineTable));
        }
    });

    private DiscretizationUtil() {
    }

    public static FieldValue discretize(Discretize discretize, FieldValue value) {
        String result = DiscretizationUtil.discretize(discretize, value.asDouble());
        return FieldValueUtil.create(discretize.getDataType(), null, result);
    }

    public static String discretize(Discretize discretize, Double value) {
        RangeMap<Double, String> binRanges = CacheUtil.getValue(discretize, binRangeCache);
        Map.Entry entry = binRanges.getEntry((Comparable)value);
        if (entry != null) {
            return (String)entry.getValue();
        }
        return discretize.getDefaultValue();
    }

    public static FieldValue mapValue(MapValues mapValues, Map<String, FieldValue> values) {
        DataType dataType = mapValues.getDataType();
        TableLocator tableLocator = mapValues.getTableLocator();
        if (tableLocator != null) {
            throw new UnsupportedFeatureException((PMMLObject)tableLocator);
        }
        InlineTable inlineTable = mapValues.getInlineTable();
        if (inlineTable != null) {
            String outputColumn = mapValues.getOutputColumn();
            if (outputColumn == null) {
                throw new InvalidFeatureException((PMMLObject)mapValues);
            }
            Map<String, String> row = DiscretizationUtil.match(inlineTable, values);
            if (row != null) {
                String result = row.get(outputColumn);
                if (result == null) {
                    throw new InvalidFeatureException((PMMLObject)inlineTable);
                }
                return FieldValueUtil.create(dataType, null, result);
            }
        }
        return FieldValueUtil.create(dataType, null, mapValues.getDefaultValue());
    }

    public static Range<Double> toRange(Interval interval) {
        Double leftMargin = interval.getLeftMargin();
        Double rightMargin = interval.getRightMargin();
        if (leftMargin == null && rightMargin == null) {
            throw new InvalidFeatureException((PMMLObject)interval);
        }
        if (leftMargin != null && rightMargin != null && leftMargin.compareTo(rightMargin) > 0) {
            throw new InvalidFeatureException((PMMLObject)interval);
        }
        Interval.Closure closure = interval.getClosure();
        switch (closure) {
            case OPEN_OPEN: {
                if (leftMargin == null) {
                    return Range.lessThan((Comparable)rightMargin);
                }
                if (rightMargin == null) {
                    return Range.greaterThan((Comparable)leftMargin);
                }
                return Range.open((Comparable)leftMargin, (Comparable)rightMargin);
            }
            case OPEN_CLOSED: {
                if (leftMargin == null) {
                    return Range.atMost((Comparable)rightMargin);
                }
                if (rightMargin == null) {
                    return Range.greaterThan((Comparable)leftMargin);
                }
                return Range.openClosed((Comparable)leftMargin, (Comparable)rightMargin);
            }
            case CLOSED_OPEN: {
                if (leftMargin == null) {
                    return Range.lessThan((Comparable)rightMargin);
                }
                if (rightMargin == null) {
                    return Range.atLeast((Comparable)leftMargin);
                }
                return Range.closedOpen((Comparable)leftMargin, (Comparable)rightMargin);
            }
            case CLOSED_CLOSED: {
                if (leftMargin == null) {
                    return Range.atMost((Comparable)rightMargin);
                }
                if (rightMargin == null) {
                    return Range.atLeast((Comparable)leftMargin);
                }
                return Range.closed((Comparable)leftMargin, (Comparable)rightMargin);
            }
        }
        throw new UnsupportedFeatureException((PMMLObject)interval, (Enum<?>)closure);
    }

    private static Map<String, String> match(InlineTable inlineTable, Map<String, FieldValue> values) {
        Map<String, RowFilter> rowFilters = CacheUtil.getValue(inlineTable, rowFilterCache);
        Set rows = null;
        Set<Map.Entry<String, FieldValue>> entries = values.entrySet();
        for (Map.Entry entry : entries) {
            String key = (String)entry.getKey();
            FieldValue value = (FieldValue)entry.getValue();
            RowFilter rowFilter = rowFilters.get(key);
            if (rowFilter == null) {
                throw new InvalidFeatureException((PMMLObject)inlineTable);
            }
            Map<FieldValue, Set<Integer>> columnRowMap = rowFilter.getValueMapping(value.getDataType(), value.getOpType());
            HashSet columnRows = columnRowMap.get(value);
            if (columnRows != null && columnRows.size() > 0) {
                if (rows == null) {
                    rows = entries.size() > 1 ? new HashSet(columnRows) : columnRows;
                } else {
                    rows.retainAll(columnRows);
                }
                if (!rows.isEmpty()) continue;
                return null;
            }
            return null;
        }
        if (rows != null && rows.size() > 0) {
            Table<Integer, String, String> content = InlineTableUtil.getContent(inlineTable);
            if (rows.size() != 1) {
                throw new EvaluationException();
            }
            Integer n = (Integer)Iterables.getOnlyElement((Iterable)rows);
            return content.row((Object)n);
        }
        return null;
    }

    private static RangeMap<Double, String> parseDiscretize(Discretize discretize) {
        TreeRangeMap result = TreeRangeMap.create();
        List discretizeBins = discretize.getDiscretizeBins();
        for (DiscretizeBin discretizeBin : discretizeBins) {
            Interval interval = discretizeBin.getInterval();
            String binValue = discretizeBin.getBinValue();
            if (interval == null || binValue == null) {
                throw new InvalidFeatureException((PMMLObject)discretizeBin);
            }
            Range<Double> range = DiscretizationUtil.toRange(interval);
            result.put(range, (Object)binValue);
        }
        return result;
    }

    private static Map<String, RowFilter> parseInlineTable(InlineTable inlineTable) {
        LinkedHashMap<String, RowFilter> result = new LinkedHashMap<String, RowFilter>();
        Table<Integer, String, String> table = InlineTableUtil.getContent(inlineTable);
        Set columns = table.columnKeySet();
        for (String column : columns) {
            Map columnValues = table.column((Object)column);
            RowFilter rowFilter = new RowFilter(columnValues);
            result.put(column, rowFilter);
        }
        return result;
    }

    private static class RowFilter
    implements HasParsedValueMapping<Set<Integer>> {
        private Map<Integer, String> columnValues = null;
        private SetMultimap<FieldValue, Integer> parsedColumnValues = null;

        private RowFilter(Map<Integer, String> columnValues) {
            this.setColumnValues(columnValues);
        }

        @Override
        public Map<FieldValue, Set<Integer>> getValueMapping(DataType dataType, OpType opType) {
            if (this.parsedColumnValues == null) {
                this.parsedColumnValues = ImmutableSetMultimap.copyOf(this.parseColumnValues(dataType, opType));
            }
            return this.parsedColumnValues.asMap();
        }

        private SetMultimap<FieldValue, Integer> parseColumnValues(DataType dataType, OpType opType) {
            HashMultimap result = HashMultimap.create();
            Map<Integer, String> columnValues = this.getColumnValues();
            Set<Map.Entry<Integer, String>> entries = columnValues.entrySet();
            for (Map.Entry entry : entries) {
                FieldValue value = FieldValueUtil.create(dataType, opType, entry.getValue());
                Integer row = (Integer)entry.getKey();
                result.put((Object)value, (Object)row);
            }
            return result;
        }

        public Map<Integer, String> getColumnValues() {
            return this.columnValues;
        }

        private void setColumnValues(Map<Integer, String> columnValues) {
            this.columnValues = columnValues;
        }
    }
}

