/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.FieldName;
import org.jpmml.evaluator.DuplicateValueException;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.MissingFieldException;

public abstract class EvaluationContext {
    private Map<FieldName, FieldValue> fields = new HashMap<FieldName, FieldValue>();
    private List<String> warnings = null;

    EvaluationContext() {
    }

    protected abstract FieldValue createFieldValue(FieldName var1, Object var2);

    void reset() {
        this.fields.clear();
        if (this.warnings != null) {
            this.warnings.clear();
        }
    }

    public FieldValue evaluate(FieldName name) {
        FieldValue value;
        Map<FieldName, FieldValue> fields = this.getFields();
        if (fields.size() > 0 && ((value = fields.get(name)) != null || value == null && fields.containsKey(name))) {
            return value;
        }
        return this.resolve(name);
    }

    protected FieldValue resolve(FieldName name) {
        throw new MissingFieldException(name);
    }

    public FieldValue getField(FieldName name) {
        Map<FieldName, FieldValue> fields = this.getFields();
        return fields.get(name);
    }

    public FieldValue declare(FieldName name, Object value) {
        if (value instanceof FieldValue) {
            return this.declare(name, (FieldValue)value);
        }
        return this.declare(name, this.createFieldValue(name, value));
    }

    public FieldValue declare(FieldName name, FieldValue value) {
        Map<FieldName, FieldValue> fields = this.getFields();
        boolean declared = fields.containsKey(name);
        if (declared) {
            throw new DuplicateValueException(name);
        }
        fields.put(name, value);
        return value;
    }

    protected void declareAll(Map<FieldName, ?> values) {
        Set<Map.Entry<FieldName, ?>> entries = values.entrySet();
        for (Map.Entry entry : entries) {
            this.declare((FieldName)entry.getKey(), entry.getValue());
        }
    }

    protected DefineFunction getDefineFunction(String name) {
        throw new UnsupportedOperationException();
    }

    public void addWarning(String warning) {
        if (this.warnings == null) {
            this.warnings = new ArrayList<String>();
        }
        this.warnings.add(warning);
    }

    public Map<FieldName, FieldValue> getFields() {
        return this.fields;
    }

    public List<String> getWarnings() {
        if (this.warnings == null) {
            return Collections.emptyList();
        }
        return this.warnings;
    }
}

