/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.base.Function;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableRangeSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Field;
import org.dmg.pmml.Interval;
import org.dmg.pmml.InvalidValueTreatmentMethodType;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.MissingValueTreatmentMethodType;
import org.dmg.pmml.OpType;
import org.dmg.pmml.OutlierTreatmentMethodType;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Target;
import org.dmg.pmml.TypeDefinitionField;
import org.dmg.pmml.Value;
import org.jpmml.evaluator.CacheUtil;
import org.jpmml.evaluator.CategoricalValue;
import org.jpmml.evaluator.ContinuousValue;
import org.jpmml.evaluator.DiscretizationUtil;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.HasParsedValueMapping;
import org.jpmml.evaluator.InvalidFeatureException;
import org.jpmml.evaluator.InvalidResultException;
import org.jpmml.evaluator.OrdinalValue;
import org.jpmml.evaluator.TypeCheckException;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.UnsupportedFeatureException;

public class FieldValueUtil {
    private static final LoadingCache<TypeDefinitionField, List<String>> targetCategoryCache = CacheUtil.buildLoadingCache(new CacheLoader<TypeDefinitionField, List<String>>(){

        public List<String> load(TypeDefinitionField field) {
            List<Value> values = FieldValueUtil.getValidValues(field);
            Function<Value, String> function = new Function<Value, String>(){

                public String apply(Value value) {
                    String result = value.getValue();
                    if (result == null) {
                        throw new InvalidFeatureException((PMMLObject)value);
                    }
                    return result;
                }
            };
            return ImmutableList.copyOf((Iterable)Iterables.transform(values, (Function)function));
        }
    });
    private static final LoadingCache<DataField, RangeSet<Double>> validRangeCache = CacheUtil.buildLoadingCache(new CacheLoader<DataField, RangeSet<Double>>(){

        public RangeSet<Double> load(DataField dataField) {
            return ImmutableRangeSet.copyOf((RangeSet)FieldValueUtil.parseValidRanges(dataField));
        }
    });

    private FieldValueUtil() {
    }

    public static FieldValue prepare(DataField dataField, MiningField miningField, Object value) {
        DataType dataType = dataField.getDataType();
        OpType opType = dataField.getOpType();
        if (dataType == null || opType == null) {
            throw new InvalidFeatureException((PMMLObject)dataField);
        }
        value = FieldValueUtil.safeParseOrCast(dataType, value);
        Value.Property status = FieldValueUtil.getStatus(dataField, miningField, value);
        switch (status) {
            case VALID: {
                return FieldValueUtil.performValidValueTreatment((Field)dataField, miningField, value);
            }
            case INVALID: {
                return FieldValueUtil.performInvalidValueTreatment((Field)dataField, miningField, value);
            }
            case MISSING: {
                return FieldValueUtil.performMissingValueTreatment((Field)dataField, miningField);
            }
        }
        throw new EvaluationException();
    }

    public static FieldValue performValidValueTreatment(Field field, MiningField miningField, Object value) {
        OutlierTreatmentMethodType outlierTreatmentMethod = miningField.getOutlierTreatment();
        Double lowValue = miningField.getLowValue();
        Double highValue = miningField.getHighValue();
        Double doubleValue = null;
        switch (outlierTreatmentMethod) {
            case AS_MISSING_VALUES: 
            case AS_EXTREME_VALUES: {
                if (lowValue == null || highValue == null) {
                    throw new InvalidFeatureException((PMMLObject)miningField);
                }
                if (lowValue.compareTo(highValue) > 0) {
                    throw new InvalidFeatureException((PMMLObject)miningField);
                }
                doubleValue = (Double)TypeUtil.parseOrCast(DataType.DOUBLE, value);
                break;
            }
        }
        switch (outlierTreatmentMethod) {
            case AS_IS: {
                break;
            }
            case AS_MISSING_VALUES: {
                if (TypeUtil.compare(DataType.DOUBLE, doubleValue, lowValue) >= 0 && TypeUtil.compare(DataType.DOUBLE, doubleValue, highValue) <= 0) break;
                return FieldValueUtil.createMissingActiveValue(field, miningField);
            }
            case AS_EXTREME_VALUES: {
                if (TypeUtil.compare(DataType.DOUBLE, doubleValue, lowValue) < 0) {
                    value = lowValue;
                    break;
                }
                if (TypeUtil.compare(DataType.DOUBLE, doubleValue, highValue) <= 0) break;
                value = highValue;
                break;
            }
            default: {
                throw new UnsupportedFeatureException((PMMLObject)miningField, (Enum<?>)outlierTreatmentMethod);
            }
        }
        return FieldValueUtil.createActiveValue(field, miningField, value);
    }

    public static FieldValue performInvalidValueTreatment(Field field, MiningField miningField, Object value) {
        InvalidValueTreatmentMethodType invalidValueTreatmentMethod = miningField.getInvalidValueTreatment();
        switch (invalidValueTreatmentMethod) {
            case AS_IS: {
                return FieldValueUtil.createActiveValue(field, miningField, value);
            }
            case AS_MISSING: {
                return FieldValueUtil.createMissingActiveValue(field, miningField);
            }
            case RETURN_INVALID: {
                throw new InvalidResultException((PMMLObject)miningField);
            }
        }
        throw new UnsupportedFeatureException((PMMLObject)miningField, (Enum<?>)invalidValueTreatmentMethod);
    }

    public static FieldValue performMissingValueTreatment(Field field, MiningField miningField) {
        MissingValueTreatmentMethodType missingValueTreatmentMethod = miningField.getMissingValueTreatment();
        if (missingValueTreatmentMethod == null) {
            missingValueTreatmentMethod = MissingValueTreatmentMethodType.AS_IS;
        }
        switch (missingValueTreatmentMethod) {
            case AS_IS: 
            case AS_MEAN: 
            case AS_MEDIAN: 
            case AS_MODE: 
            case AS_VALUE: {
                return FieldValueUtil.createMissingActiveValue(field, miningField);
            }
        }
        throw new UnsupportedFeatureException((PMMLObject)miningField, (Enum<?>)missingValueTreatmentMethod);
    }

    public static Value.Property getStatus(DataField dataField, MiningField miningField, Object value) {
        OpType opType;
        if (value == null) {
            return Value.Property.MISSING;
        }
        boolean hasValidSpace = false;
        if (dataField.hasValues()) {
            HasParsedValueMapping hasParsedValueMapping;
            Value fieldValue;
            DataType dataType = dataField.getDataType();
            opType = dataField.getOpType();
            if (dataField instanceof HasParsedValueMapping && (fieldValue = FieldValueUtil.getValidValue(hasParsedValueMapping = (HasParsedValueMapping)dataField, dataType, opType, value)) != null) {
                return Value.Property.VALID;
            }
            List fieldValues = dataField.getValues();
            block8: for (Value fieldValue2 : fieldValues) {
                Value.Property property = fieldValue2.getProperty();
                switch (property) {
                    case VALID: {
                        hasValidSpace = true;
                    }
                    case INVALID: 
                    case MISSING: {
                        boolean equals = FieldValueUtil.equals(dataType, value, fieldValue2.getValue());
                        if (!equals) continue block8;
                        return property;
                    }
                    default: {
                        throw new UnsupportedFeatureException((PMMLObject)fieldValue2, (Enum<?>)property);
                    }
                }
            }
        }
        MiningField locatable = miningField;
        opType = miningField.getOpType();
        if (opType == null) {
            locatable = dataField;
            opType = dataField.getOpType();
        }
        switch (opType) {
            case CONTINUOUS: {
                Double doubleValue;
                if (!dataField.hasIntervals()) break;
                RangeSet<Double> validRanges = FieldValueUtil.getValidRanges(dataField);
                return validRanges.contains((Comparable)(doubleValue = (Double)TypeUtil.parseOrCast(DataType.DOUBLE, value))) ? Value.Property.VALID : Value.Property.INVALID;
            }
            case CATEGORICAL: 
            case ORDINAL: {
                if (!dataField.hasIntervals()) break;
                throw new InvalidFeatureException((PMMLObject)dataField);
            }
            default: {
                throw new UnsupportedFeatureException((PMMLObject)locatable, (Enum<?>)opType);
            }
        }
        if (hasValidSpace) {
            return Value.Property.INVALID;
        }
        return Value.Property.VALID;
    }

    public static FieldValue createActiveValue(Field field, MiningField miningField, Object value) {
        if (value == null) {
            return null;
        }
        DataType dataType = field.getDataType();
        OpType opType = field.getOpType();
        if (miningField != null) {
            opType = FieldValueUtil.firstNonNull(miningField.getOpType(), opType);
        }
        return FieldValueUtil.create(dataType, opType, value);
    }

    public static FieldValue createMissingActiveValue(Field field, MiningField miningField) {
        return FieldValueUtil.createActiveValue(field, miningField, miningField.getMissingValueReplacement());
    }

    public static FieldValue createTargetValue(Field field, MiningField miningField, Target target, Object value) {
        if (value == null) {
            return null;
        }
        DataType dataType = field.getDataType();
        OpType opType = field.getOpType();
        if (miningField != null) {
            opType = FieldValueUtil.firstNonNull(miningField.getOpType(), opType);
            if (target != null) {
                opType = FieldValueUtil.firstNonNull(target.getOpType(), opType);
            }
        }
        return FieldValueUtil.create(dataType, opType, value);
    }

    public static FieldValue create(Object value) {
        return FieldValueUtil.create(null, null, value);
    }

    public static List<FieldValue> createAll(List<?> values) {
        Function<Object, FieldValue> function = new Function<Object, FieldValue>(){

            public FieldValue apply(Object value) {
                return FieldValueUtil.create(value);
            }
        };
        return Lists.transform(values, (Function)function);
    }

    public static FieldValue create(Field field, Object value) {
        FieldValue result = FieldValueUtil.create(field.getDataType(), field.getOpType(), value);
        if (field instanceof TypeDefinitionField) {
            return FieldValueUtil.enhance((TypeDefinitionField)field, result);
        }
        return result;
    }

    public static FieldValue create(DataType dataType, OpType opType, Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            if (dataType == null) {
                Object firstElement = Iterables.getFirst((Iterable)collection, null);
                dataType = firstElement != null ? TypeUtil.getDataType(firstElement) : DataType.STRING;
            }
            if (opType == null) {
                opType = TypeUtil.getOpType(dataType);
            }
        } else {
            if (dataType == null) {
                dataType = TypeUtil.getDataType(value);
            } else {
                value = TypeUtil.parseOrCast(dataType, value);
            }
            if (opType == null) {
                opType = TypeUtil.getOpType(dataType);
            }
        }
        switch (opType) {
            case CONTINUOUS: {
                return ContinuousValue.create(dataType, value);
            }
            case CATEGORICAL: {
                return CategoricalValue.create(dataType, value);
            }
            case ORDINAL: {
                return OrdinalValue.create(dataType, value);
            }
        }
        throw new EvaluationException();
    }

    public static FieldValue refine(Field field, FieldValue value) {
        FieldValue result = FieldValueUtil.refine(field.getDataType(), field.getOpType(), value);
        if (field instanceof TypeDefinitionField && result != value) {
            return FieldValueUtil.enhance((TypeDefinitionField)field, result);
        }
        return result;
    }

    public static FieldValue refine(DataType dataType, OpType opType, FieldValue value) {
        if (value == null) {
            return null;
        }
        DataType valueDataType = value.getDataType();
        OpType valueOpType = value.getOpType();
        DataType refinedDataType = FieldValueUtil.firstNonNull(dataType, valueDataType);
        OpType refinedOpType = FieldValueUtil.firstNonNull(opType, valueOpType);
        if (refinedDataType.equals((Object)valueDataType) && refinedOpType.equals((Object)valueOpType)) {
            return value;
        }
        return FieldValueUtil.create(refinedDataType, refinedOpType, value.getValue());
    }

    private static FieldValue enhance(TypeDefinitionField field, FieldValue value) {
        if (value == null) {
            return null;
        }
        if (value instanceof OrdinalValue) {
            OrdinalValue ordinalValue = (OrdinalValue)value;
            ordinalValue.setOrdering(FieldValueUtil.getOrdering(field, ordinalValue.getDataType()));
        }
        return value;
    }

    public static Object getValue(FieldValue value) {
        return value != null ? value.getValue() : null;
    }

    public static <V> V getValue(Class<? extends V> clazz, FieldValue value) {
        return TypeUtil.cast(clazz, FieldValueUtil.getValue(value));
    }

    public static Value getValidValue(TypeDefinitionField field, Object value) {
        if (field.hasValues()) {
            DataType dataType = field.getDataType();
            OpType opType = field.getOpType();
            value = FieldValueUtil.safeParseOrCast(dataType, value);
            if (field instanceof HasParsedValueMapping) {
                HasParsedValueMapping hasParsedValueMapping = (HasParsedValueMapping)field;
                return FieldValueUtil.getValidValue(hasParsedValueMapping, dataType, opType, value);
            }
            List fieldValues = field.getValues();
            block4: for (Value fieldValue : fieldValues) {
                Value.Property property = fieldValue.getProperty();
                switch (property) {
                    case VALID: {
                        boolean equals = FieldValueUtil.equals(dataType, value, fieldValue.getValue());
                        if (!equals) continue block4;
                        return fieldValue;
                    }
                    case INVALID: 
                    case MISSING: {
                        break;
                    }
                    default: {
                        throw new UnsupportedFeatureException((PMMLObject)fieldValue, (Enum<?>)property);
                    }
                }
            }
        }
        return null;
    }

    private static Value getValidValue(HasParsedValueMapping<?> hasParsedValueMapping, DataType dataType, OpType opType, Object object) {
        FieldValue value;
        try {
            value = FieldValueUtil.create(dataType, opType, object);
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
        Map<FieldValue, ?> fieldValues = hasParsedValueMapping.getValueMapping(dataType, opType);
        return (Value)fieldValues.get(value);
    }

    public static List<Value> getValidValues(TypeDefinitionField field) {
        if (field.hasValues()) {
            List fieldValues = field.getValues();
            ArrayList<Value> result = new ArrayList<Value>(fieldValues.size());
            int max = fieldValues.size();
            block4: for (int i = 0; i < max; ++i) {
                Value fieldValue = (Value)fieldValues.get(i);
                Value.Property property = fieldValue.getProperty();
                switch (property) {
                    case VALID: {
                        result.add(fieldValue);
                        continue block4;
                    }
                    case INVALID: 
                    case MISSING: {
                        continue block4;
                    }
                    default: {
                        throw new UnsupportedFeatureException((PMMLObject)fieldValue, (Enum<?>)property);
                    }
                }
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static List<String> getTargetCategories(TypeDefinitionField field) {
        return CacheUtil.getValue(field, targetCategoryCache);
    }

    public static RangeSet<Double> getValidRanges(DataField dataField) {
        return CacheUtil.getValue(dataField, validRangeCache);
    }

    private static Object safeParseOrCast(DataType dataType, Object value) {
        if (value != null) {
            try {
                return TypeUtil.parseOrCast(dataType, value);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return value;
    }

    private static boolean equals(DataType dataType, Object value, String referenceValue) {
        try {
            return TypeUtil.equals(dataType, value, TypeUtil.parseOrCast(dataType, referenceValue));
        }
        catch (IllegalArgumentException iae) {
            try {
                return TypeUtil.equals(DataType.STRING, value, referenceValue);
            }
            catch (TypeCheckException tce) {
                throw iae;
            }
        }
    }

    private static <V> V firstNonNull(V value, V defaultValue) {
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    private static RangeSet<Double> parseValidRanges(DataField dataField) {
        TreeRangeSet result = TreeRangeSet.create();
        List intervals = dataField.getIntervals();
        for (Interval interval : intervals) {
            Range<Double> range = DiscretizationUtil.toRange(interval);
            result.add(range);
        }
        return result;
    }

    private static List<?> getOrdering(TypeDefinitionField field, final DataType dataType) {
        List<Value> values = FieldValueUtil.getValidValues(field);
        if (values.isEmpty()) {
            return null;
        }
        Function<Value, Object> function = new Function<Value, Object>(){

            public Object apply(Value value) {
                return TypeUtil.parse(dataType, value.getValue());
            }
        };
        return Lists.newArrayList((Iterable)Iterables.transform(values, (Function)function));
    }
}

