/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.base.Function;
import java.util.Map;
import java.util.Set;
import org.jpmml.evaluator.ClassificationAggregator;
import org.jpmml.evaluator.DoubleVector;
import org.jpmml.evaluator.HasProbability;

class ProbabilityAggregator
extends ClassificationAggregator<String> {
    ProbabilityAggregator() {
        this(0);
    }

    ProbabilityAggregator(int capacity) {
        super(capacity);
    }

    public void add(HasProbability hasProbability) {
        this.add(hasProbability, 1.0);
    }

    @Override
    public void add(HasProbability hasProbability, double weight) {
        Set<String> categories = hasProbability.getCategoryValues();
        for (String category : categories) {
            Double probability = hasProbability.getProbability(category);
            this.add(category, probability * weight);
        }
    }

    public Map<String, Double> maxMap() {
        Function<DoubleVector, Double> function = new Function<DoubleVector, Double>(){

            public Double apply(DoubleVector values) {
                return values.max();
            }
        };
        return this.transform(function);
    }

    public Map<String, Double> medianMap() {
        Function<DoubleVector, Double> function = new Function<DoubleVector, Double>(){

            public Double apply(DoubleVector values) {
                return values.median();
            }
        };
        return this.transform(function);
    }

    public Map<String, Double> averageMap(final double denominator) {
        Function<DoubleVector, Double> function = new Function<DoubleVector, Double>(){

            public Double apply(DoubleVector values) {
                return values.sum() / denominator;
            }
        };
        return this.transform(function);
    }
}

