/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Target;
import org.dmg.pmml.TargetValue;
import org.jpmml.evaluator.Classification;
import org.jpmml.evaluator.Evaluator;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.InvalidFeatureException;
import org.jpmml.evaluator.MissingFieldException;
import org.jpmml.evaluator.ModelEvaluationContext;
import org.jpmml.evaluator.ModelEvaluator;
import org.jpmml.evaluator.ProbabilityDistribution;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.UnsupportedFeatureException;

public class TargetUtil {
    private TargetUtil() {
    }

    public static Map<FieldName, ?> evaluateRegressionDefault(ModelEvaluationContext context) {
        return TargetUtil.evaluateRegression(null, context);
    }

    public static Map<FieldName, ?> evaluateRegression(Double value, ModelEvaluationContext context) {
        ModelEvaluator<?> evaluator = context.getModelEvaluator();
        return TargetUtil.evaluateRegression(evaluator.getTargetField(), value, context);
    }

    public static Map<FieldName, ?> evaluateRegression(FieldName name, Double value, ModelEvaluationContext context) {
        return Collections.singletonMap(name, TargetUtil.evaluateRegressionInternal(name, value, context));
    }

    static Object evaluateRegressionInternal(FieldName name, Object value, ModelEvaluationContext context) {
        ModelEvaluator<?> evaluator = context.getModelEvaluator();
        if (Objects.equals(Evaluator.DEFAULT_TARGET, name)) {
            DataField dataField = evaluator.getDataField();
            if (value != null) {
                value = TypeUtil.cast(dataField.getDataType(), value);
            }
        } else {
            DataField dataField;
            Target target = evaluator.getTarget(name);
            if (target != null) {
                if (value == null) {
                    value = TargetUtil.getDefaultValue(target);
                }
                if (value != null) {
                    value = TargetUtil.processValue(target, (Double)value);
                }
            }
            if ((dataField = evaluator.getDataField(name)) == null) {
                throw new MissingFieldException(name);
            }
            if (value != null) {
                value = TypeUtil.cast(dataField.getDataType(), value);
            }
            MiningField miningField = evaluator.getMiningField(name);
            context.declare(name, FieldValueUtil.createTargetValue((Field)dataField, miningField, target, value));
        }
        return value;
    }

    public static Map<FieldName, ? extends Classification> evaluateClassificationDefault(ModelEvaluationContext context) {
        return TargetUtil.evaluateClassification(null, context);
    }

    public static Map<FieldName, ? extends Classification> evaluateClassification(Classification value, ModelEvaluationContext context) {
        ModelEvaluator<?> evaluator = context.getModelEvaluator();
        return TargetUtil.evaluateClassification(evaluator.getTargetField(), value, context);
    }

    public static Map<FieldName, ? extends Classification> evaluateClassification(FieldName name, Classification value, ModelEvaluationContext context) {
        return Collections.singletonMap(name, TargetUtil.evaluateClassificationInternal(name, value, context));
    }

    static Classification evaluateClassificationInternal(FieldName name, Classification value, ModelEvaluationContext context) {
        ModelEvaluator<?> evaluator = context.getModelEvaluator();
        if (Objects.equals(Evaluator.DEFAULT_TARGET, name)) {
            DataField dataField = evaluator.getDataField();
            if (value != null) {
                value.computeResult(dataField.getDataType());
            }
        } else {
            DataField dataField;
            Target target = evaluator.getTarget(name);
            if (target != null && value == null) {
                value = TargetUtil.getPriorProbabilities(target);
            }
            if ((dataField = evaluator.getDataField(name)) == null) {
                throw new MissingFieldException(name);
            }
            if (value != null) {
                value.computeResult(dataField.getDataType());
            }
            MiningField miningField = evaluator.getMiningField(name);
            context.declare(name, FieldValueUtil.createTargetValue((Field)dataField, miningField, target, value != null ? value.getResult() : null));
        }
        return value;
    }

    public static Double processValue(Target target, Double value) {
        Double max;
        double result = value;
        Double min = target.getMin();
        if (min != null) {
            result = Math.max(result, min);
        }
        if ((max = target.getMax()) != null) {
            result = Math.min(result, max);
        }
        result = result * target.getRescaleFactor() + target.getRescaleConstant();
        Target.CastInteger castInteger = target.getCastInteger();
        if (castInteger == null) {
            return result;
        }
        switch (castInteger) {
            case ROUND: {
                return Math.round(result);
            }
            case CEILING: {
                return Math.ceil(result);
            }
            case FLOOR: {
                return Math.floor(result);
            }
        }
        throw new UnsupportedFeatureException((PMMLObject)target, (Enum<?>)castInteger);
    }

    public static TargetValue getTargetValue(Target target, Object value) {
        DataType dataType = TypeUtil.getDataType(value);
        List targetValues = target.getTargetValues();
        for (TargetValue targetValue : targetValues) {
            if (!TypeUtil.equals(dataType, value, TypeUtil.parseOrCast(dataType, targetValue.getValue()))) continue;
            return targetValue;
        }
        return null;
    }

    private static Double getDefaultValue(Target target) {
        List values = target.getTargetValues();
        if (values.isEmpty()) {
            return null;
        }
        if (values.size() != 1) {
            throw new InvalidFeatureException((PMMLObject)target);
        }
        TargetValue value = (TargetValue)values.get(0);
        if (value.getValue() != null || value.getPriorProbability() != null) {
            throw new InvalidFeatureException((PMMLObject)value);
        }
        return value.getDefaultValue();
    }

    private static ProbabilityDistribution getPriorProbabilities(Target target) {
        ProbabilityDistribution result = new ProbabilityDistribution();
        List values = target.getTargetValues();
        for (TargetValue value : values) {
            if (value.getDefaultValue() != null) {
                throw new InvalidFeatureException((PMMLObject)value);
            }
            String targetCategory = value.getValue();
            Double probability = value.getPriorProbability();
            if (targetCategory == null || probability == null) continue;
            result.put(targetCategory, probability);
        }
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }
}

