/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableBiMap;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dmg.pmml.AssociationModel;
import org.dmg.pmml.AssociationRule;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.Item;
import org.dmg.pmml.ItemRef;
import org.dmg.pmml.Itemset;
import org.dmg.pmml.MiningFunctionType;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Target;
import org.jpmml.evaluator.Association;
import org.jpmml.evaluator.CacheUtil;
import org.jpmml.evaluator.EntityUtil;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.HasEntityRegistry;
import org.jpmml.evaluator.IndexableUtil;
import org.jpmml.evaluator.InvalidFeatureException;
import org.jpmml.evaluator.InvalidResultException;
import org.jpmml.evaluator.MissingValueException;
import org.jpmml.evaluator.ModelEvaluationContext;
import org.jpmml.evaluator.ModelEvaluator;
import org.jpmml.evaluator.OutputUtil;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.UnsupportedFeatureException;

public class AssociationModelEvaluator
extends ModelEvaluator<AssociationModel>
implements HasEntityRegistry<AssociationRule> {
    private transient BiMap<String, AssociationRule> entityRegistry = null;
    private transient Map<String, Item> items = null;
    private transient Map<String, Itemset> itemsets = null;
    private transient BiMap<String, String> itemValues = null;
    private static final LoadingCache<AssociationModel, BiMap<String, AssociationRule>> entityCache = CacheUtil.buildLoadingCache(new CacheLoader<AssociationModel, BiMap<String, AssociationRule>>(){

        public BiMap<String, AssociationRule> load(AssociationModel associationModel) {
            return EntityUtil.buildBiMap(associationModel.getAssociationRules());
        }
    });
    private static final LoadingCache<AssociationModel, Map<String, Item>> itemCache = CacheUtil.buildLoadingCache(new CacheLoader<AssociationModel, Map<String, Item>>(){

        public Map<String, Item> load(AssociationModel associationModel) {
            return IndexableUtil.buildMap(associationModel.getItems());
        }
    });
    private static final LoadingCache<AssociationModel, Map<String, Itemset>> itemsetCache = CacheUtil.buildLoadingCache(new CacheLoader<AssociationModel, Map<String, Itemset>>(){

        public Map<String, Itemset> load(AssociationModel associationModel) {
            return IndexableUtil.buildMap(associationModel.getItemsets());
        }
    });
    private static final LoadingCache<AssociationModel, BiMap<String, String>> itemValueCache = CacheUtil.buildLoadingCache(new CacheLoader<AssociationModel, BiMap<String, String>>(){

        public BiMap<String, String> load(AssociationModel associationModel) {
            return ImmutableBiMap.copyOf((Map)AssociationModelEvaluator.parseItemValues(associationModel));
        }
    });

    public AssociationModelEvaluator(PMML pmml) {
        super(pmml, AssociationModel.class);
    }

    public AssociationModelEvaluator(PMML pmml, AssociationModel associationModel) {
        super(pmml, associationModel);
    }

    @Override
    public String getSummary() {
        return "Association rules";
    }

    @Override
    public Target getTarget(FieldName name) {
        return null;
    }

    @Override
    public BiMap<String, AssociationRule> getEntityRegistry() {
        if (this.entityRegistry == null) {
            this.entityRegistry = this.getValue(entityCache);
        }
        return this.entityRegistry;
    }

    @Override
    public void verify() {
        AssociationModel associationModel = (AssociationModel)this.getModel();
        List<FieldName> targetFields = this.getTargetFields();
        if (targetFields.size() > 0) {
            MiningSchema miningSchema = associationModel.getMiningSchema();
            throw new InvalidFeatureException("Too many target fields", (PMMLObject)miningSchema);
        }
        super.verify();
    }

    @Override
    public Map<FieldName, ?> evaluate(ModelEvaluationContext context) {
        Map<FieldName, Association> predictions;
        AssociationModel associationModel = (AssociationModel)this.getModel();
        if (!associationModel.isScorable()) {
            throw new InvalidResultException((PMMLObject)associationModel);
        }
        MiningFunctionType miningFunction = associationModel.getFunctionName();
        switch (miningFunction) {
            case ASSOCIATION_RULES: {
                predictions = this.evaluateAssociationRules(context);
                break;
            }
            default: {
                throw new UnsupportedFeatureException((PMMLObject)associationModel, (Enum<?>)miningFunction);
            }
        }
        return OutputUtil.evaluate(predictions, context);
    }

    private Map<FieldName, Association> evaluateAssociationRules(EvaluationContext context) {
        AssociationModel associationModel = (AssociationModel)this.getModel();
        Collection<?> activeValue = this.getActiveValue(context);
        Set<String> input = this.createInput(activeValue, context);
        HashMap<String, Boolean> flags = new HashMap<String, Boolean>();
        List itemsets = associationModel.getItemsets();
        for (Itemset itemset : itemsets) {
            flags.put(itemset.getId(), AssociationModelEvaluator.isSubset(input, itemset));
        }
        List associationRules = associationModel.getAssociationRules();
        BitSet antecedentFlags = new BitSet(associationRules.size());
        BitSet consequentFlags = new BitSet(associationRules.size());
        for (int i = 0; i < associationRules.size(); ++i) {
            AssociationRule associationRule = (AssociationRule)associationRules.get(i);
            Boolean antecedentFlag = (Boolean)flags.get(associationRule.getAntecedent());
            if (antecedentFlag == null) {
                throw new InvalidFeatureException((PMMLObject)associationRule);
            }
            antecedentFlags.set(i, antecedentFlag);
            Boolean consequentFlag = (Boolean)flags.get(associationRule.getConsequent());
            if (consequentFlag == null) {
                throw new InvalidFeatureException((PMMLObject)associationRule);
            }
            consequentFlags.set(i, consequentFlag);
        }
        Association association = new Association(associationRules, antecedentFlags, consequentFlags){

            @Override
            public Map<String, Item> getItems() {
                return AssociationModelEvaluator.this.getItems();
            }

            @Override
            public Map<String, Itemset> getItemsets() {
                return AssociationModelEvaluator.this.getItemsets();
            }

            @Override
            public BiMap<String, AssociationRule> getAssociationRuleRegistry() {
                return AssociationModelEvaluator.this.getEntityRegistry();
            }
        };
        return Collections.singletonMap(this.getTargetField(), association);
    }

    public Collection<?> getActiveValue(EvaluationContext context) {
        AssociationModel associationModel = (AssociationModel)this.getModel();
        List<FieldName> activeFields = this.getActiveFields();
        List<FieldName> groupFields = this.getGroupFields();
        MiningSchema miningSchema = associationModel.getMiningSchema();
        if (groupFields.size() == 0) {
            if (activeFields.size() < 1) {
                throw new InvalidFeatureException("No active fields", (PMMLObject)miningSchema);
            }
            ArrayList<String> result = new ArrayList<String>();
            for (FieldName activeField : activeFields) {
                FieldValue value = context.evaluate(activeField);
                if (value == null) continue;
                if (value.equalsString("T")) {
                    result.add(activeField.getValue());
                    continue;
                }
                if (value.equalsString("F")) continue;
                throw new EvaluationException();
            }
            return result;
        }
        if (groupFields.size() == 1) {
            if (activeFields.size() < 1) {
                throw new InvalidFeatureException("No active fields", (PMMLObject)miningSchema);
            }
            if (activeFields.size() > 1) {
                throw new InvalidFeatureException("Too many active fields", (PMMLObject)miningSchema);
            }
            FieldName activeField = activeFields.get(0);
            FieldValue value = context.evaluate(activeField);
            if (value == null) {
                throw new MissingValueException(activeField);
            }
            Collection result = FieldValueUtil.getValue(Collection.class, value);
            return result;
        }
        throw new InvalidFeatureException((PMMLObject)miningSchema);
    }

    private Set<String> createInput(Collection<?> values, EvaluationContext context) {
        HashSet<String> result = new HashSet<String>();
        BiMap valueItems = this.getItemValues().inverse();
        for (Object value : values) {
            String stringValue = TypeUtil.format(value);
            String id = (String)valueItems.get(stringValue);
            if (id == null) {
                context.addWarning("Unknown item value \"" + stringValue + "\"");
                continue;
            }
            result.add(id);
        }
        return result;
    }

    private static boolean isSubset(Set<String> input, Itemset itemset) {
        boolean result = true;
        List itemRefs = itemset.getItemRefs();
        for (ItemRef itemRef : itemRefs) {
            if (result &= input.contains(itemRef.getItemRef())) continue;
            return false;
        }
        return result;
    }

    private Map<String, Item> getItems() {
        if (this.items == null) {
            this.items = this.getValue(itemCache);
        }
        return this.items;
    }

    private Map<String, Itemset> getItemsets() {
        if (this.itemsets == null) {
            this.itemsets = this.getValue(itemsetCache);
        }
        return this.itemsets;
    }

    private BiMap<String, String> getItemValues() {
        if (this.itemValues == null) {
            this.itemValues = this.getValue(itemValueCache);
        }
        return this.itemValues;
    }

    private static BiMap<String, String> parseItemValues(AssociationModel associationModel) {
        HashBiMap result = HashBiMap.create();
        List items = associationModel.getItems();
        for (Item item : items) {
            result.put((Object)item.getId(), (Object)item.getValue());
        }
        return result;
    }
}

