/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.collect.ForwardingMap;
import java.util.Map;
import org.dmg.pmml.DataType;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Segment;
import org.jpmml.evaluator.EvaluatorUtil;
import org.jpmml.evaluator.HasEntityId;
import org.jpmml.evaluator.PMMLException;
import org.jpmml.evaluator.TypeCheckException;
import org.jpmml.evaluator.TypeUtil;

class SegmentResult
extends ForwardingMap<FieldName, Object>
implements HasEntityId {
    private Segment segment = null;
    private String segmentId = null;
    private Map<FieldName, ?> result = null;
    private FieldName targetField = null;

    public SegmentResult(Segment segment, String segmentId, Map<FieldName, ?> result, FieldName targetField) {
        this.setSegment(segment);
        this.setSegmentId(segmentId);
        this.setResult(result);
        this.setTargetField(targetField);
    }

    @Override
    public String getEntityId() {
        return this.getSegmentId();
    }

    public Map<FieldName, Object> delegate() {
        Map<FieldName, Object> result = this.getResult();
        return result;
    }

    public double getWeight() {
        Segment segment = this.getSegment();
        return segment.getWeight();
    }

    public Object getTargetValue() {
        return this.get(this.getTargetField());
    }

    public Object getTargetValue(DataType dataType) {
        Object targetValue = EvaluatorUtil.decode(this.getTargetValue());
        try {
            return TypeUtil.cast(dataType, targetValue);
        }
        catch (TypeCheckException tce) {
            throw this.ensureContext(tce);
        }
    }

    public <V> V getTargetValue(Class<V> clazz) {
        Object targetValue = this.getTargetValue();
        try {
            return TypeUtil.cast(clazz, targetValue);
        }
        catch (TypeCheckException tce) {
            throw this.ensureContext(tce);
        }
    }

    public Segment getSegment() {
        return this.segment;
    }

    private void setSegment(Segment segment) {
        this.segment = segment;
    }

    public String getSegmentId() {
        return this.segmentId;
    }

    private void setSegmentId(String segmentId) {
        this.segmentId = segmentId;
    }

    public Map<FieldName, ?> getResult() {
        return this.result;
    }

    private void setResult(Map<FieldName, ?> result) {
        this.result = result;
    }

    public FieldName getTargetField() {
        return this.targetField;
    }

    private void setTargetField(FieldName targetField) {
        this.targetField = targetField;
    }

    private <E extends PMMLException> E ensureContext(E exception) {
        Segment segment = this.getSegment();
        exception.ensureContext((PMMLObject)segment);
        return exception;
    }
}

