/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.visitors;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import org.dmg.pmml.AssociationModel;
import org.dmg.pmml.ClusteringModel;
import org.dmg.pmml.Coefficients;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.Itemset;
import org.dmg.pmml.NeuralInputs;
import org.dmg.pmml.NeuralLayer;
import org.dmg.pmml.NeuralNetwork;
import org.dmg.pmml.NeuralOutputs;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.SupportVectors;
import org.dmg.pmml.VectorDictionary;
import org.dmg.pmml.VectorFields;
import org.dmg.pmml.VisitorAction;
import org.jpmml.evaluator.InvalidFeatureException;
import org.jpmml.evaluator.visitors.FeatureInspector;
import org.jpmml.model.ReflectionUtil;

public class InvalidFeatureInspector
extends FeatureInspector<InvalidFeatureException> {
    @Override
    public VisitorAction visit(PMMLObject object) {
        List fields = ReflectionUtil.getInstanceFields(object.getClass());
        for (Field field : fields) {
            XmlAttribute attribute;
            List collection;
            Object value = ReflectionUtil.getFieldValue((Field)field, (Object)object);
            if (value instanceof List && (collection = (List)value).size() == 0) {
                value = null;
            }
            if (value != null) continue;
            XmlElement element = field.getAnnotation(XmlElement.class);
            if (element != null && element.required()) {
                this.report(new InvalidFeatureException(object, field));
            }
            if ((attribute = field.getAnnotation(XmlAttribute.class)) == null || !attribute.required()) continue;
            this.report(new InvalidFeatureException(object, field));
        }
        return super.visit(object);
    }

    public VisitorAction visit(final AssociationModel associationModel) {
        this.check(new CollectionSize((PMMLObject)associationModel){

            @Override
            public Integer getSize() {
                return associationModel.getNumberOfItems();
            }

            @Override
            public Collection<?> getCollection() {
                return associationModel.getItems();
            }

            @Override
            public boolean evaluate(int left, int right) {
                return left >= right;
            }
        });
        this.check(new CollectionSize((PMMLObject)associationModel){

            @Override
            public Integer getSize() {
                return associationModel.getNumberOfItemsets();
            }

            @Override
            public Collection<?> getCollection() {
                return associationModel.getItemsets();
            }
        });
        this.check(new CollectionSize((PMMLObject)associationModel){

            @Override
            public Integer getSize() {
                return associationModel.getNumberOfRules();
            }

            @Override
            public Collection<?> getCollection() {
                return associationModel.getAssociationRules();
            }
        });
        return super.visit(associationModel);
    }

    public VisitorAction visit(final ClusteringModel clusteringModel) {
        this.check(new CollectionSize((PMMLObject)clusteringModel){

            @Override
            public Integer getSize() {
                return clusteringModel.getNumberOfClusters();
            }

            @Override
            public Collection<?> getCollection() {
                return clusteringModel.getClusters();
            }
        });
        return super.visit(clusteringModel);
    }

    public VisitorAction visit(final Coefficients coefficients) {
        this.check(new CollectionSize((PMMLObject)coefficients){

            @Override
            public Integer getSize() {
                return coefficients.getNumberOfCoefficients();
            }

            @Override
            public Collection<?> getCollection() {
                return coefficients.getCoefficients();
            }
        });
        return super.visit(coefficients);
    }

    public VisitorAction visit(final DataDictionary dataDictionary) {
        this.check(new CollectionSize((PMMLObject)dataDictionary){

            @Override
            public Integer getSize() {
                return dataDictionary.getNumberOfFields();
            }

            @Override
            public Collection<?> getCollection() {
                return dataDictionary.getDataFields();
            }
        });
        return super.visit(dataDictionary);
    }

    public VisitorAction visit(final Itemset itemset) {
        this.check(new CollectionSize((PMMLObject)itemset){

            @Override
            public Integer getSize() {
                return itemset.getNumberOfItems();
            }

            @Override
            public Collection<?> getCollection() {
                return itemset.getItemRefs();
            }
        });
        return super.visit(itemset);
    }

    public VisitorAction visit(final NeuralInputs neuralInputs) {
        this.check(new CollectionSize((PMMLObject)neuralInputs){

            @Override
            public Integer getSize() {
                return neuralInputs.getNumberOfInputs();
            }

            @Override
            public Collection<?> getCollection() {
                return neuralInputs.getNeuralInputs();
            }
        });
        return super.visit(neuralInputs);
    }

    public VisitorAction visit(final NeuralLayer neuralLayer) {
        this.check(new CollectionSize((PMMLObject)neuralLayer){

            @Override
            public Integer getSize() {
                return neuralLayer.getNumberOfNeurons();
            }

            @Override
            public Collection<?> getCollection() {
                return neuralLayer.getNeurons();
            }
        });
        return super.visit(neuralLayer);
    }

    public VisitorAction visit(final NeuralNetwork neuralNetwork) {
        this.check(new CollectionSize((PMMLObject)neuralNetwork){

            @Override
            public Integer getSize() {
                return neuralNetwork.getNumberOfLayers();
            }

            @Override
            public Collection<?> getCollection() {
                return neuralNetwork.getNeuralLayers();
            }
        });
        return super.visit(neuralNetwork);
    }

    public VisitorAction visit(final NeuralOutputs neuralOutputs) {
        this.check(new CollectionSize((PMMLObject)neuralOutputs){

            @Override
            public Integer getSize() {
                return neuralOutputs.getNumberOfOutputs();
            }

            @Override
            public Collection<?> getCollection() {
                return neuralOutputs.getNeuralOutputs();
            }
        });
        return super.visit(neuralOutputs);
    }

    public VisitorAction visit(final SupportVectors supportVectors) {
        this.check(new CollectionSize((PMMLObject)supportVectors){

            @Override
            public Integer getSize() {
                return supportVectors.getNumberOfSupportVectors();
            }

            @Override
            public Collection<?> getCollection() {
                return supportVectors.getSupportVectors();
            }
        });
        return super.visit(supportVectors);
    }

    public VisitorAction visit(final VectorDictionary vectorDictionary) {
        this.check(new CollectionSize((PMMLObject)vectorDictionary){

            @Override
            public Integer getSize() {
                return vectorDictionary.getNumberOfVectors();
            }

            @Override
            public Collection<?> getCollection() {
                return vectorDictionary.getVectorInstances();
            }
        });
        return super.visit(vectorDictionary);
    }

    public VisitorAction visit(final VectorFields vectorFields) {
        this.check(new CollectionSize((PMMLObject)vectorFields){

            @Override
            public Integer getSize() {
                return vectorFields.getNumberOfFields();
            }

            @Override
            public Collection<?> getCollection() {
                return vectorFields.getFieldRefs();
            }
        });
        return super.visit(vectorFields);
    }

    private void check(Condition condition) {
        boolean result = condition.evaluate();
        if (!result) {
            PMMLObject object = condition.getObject();
            if (object != null) {
                this.report(new InvalidFeatureException(object));
            } else {
                this.report(new InvalidFeatureException());
            }
        }
    }

    private abstract class CollectionSize
    extends Condition {
        public CollectionSize(PMMLObject object) {
            super(object);
        }

        public abstract Integer getSize();

        public abstract Collection<?> getCollection();

        @Override
        public boolean evaluate() {
            Integer size = this.getSize();
            if (size != null) {
                Collection<?> collection = this.getCollection();
                return this.evaluate(size, collection.size());
            }
            return true;
        }

        public boolean evaluate(int left, int right) {
            return left == right;
        }
    }

    private abstract class Condition {
        private PMMLObject object = null;

        public Condition(PMMLObject object) {
            this.setObject(object);
        }

        public abstract boolean evaluate();

        public PMMLObject getObject() {
            return this.object;
        }

        private void setObject(PMMLObject object) {
            this.object = object;
        }
    }
}

