/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.visitors;

import org.dmg.pmml.ActivationFunctionType;
import org.dmg.pmml.Aggregate;
import org.dmg.pmml.BaselineModel;
import org.dmg.pmml.Categories;
import org.dmg.pmml.CenterFields;
import org.dmg.pmml.ClusteringModel;
import org.dmg.pmml.DecisionTree;
import org.dmg.pmml.FeatureType;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.Matrix;
import org.dmg.pmml.MissingValueStrategyType;
import org.dmg.pmml.NeuralLayer;
import org.dmg.pmml.NeuralNetwork;
import org.dmg.pmml.NormDiscrete;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Predictor;
import org.dmg.pmml.Regression;
import org.dmg.pmml.Segmentation;
import org.dmg.pmml.SequenceModel;
import org.dmg.pmml.SupportVectorMachineModel;
import org.dmg.pmml.SvmRepresentationType;
import org.dmg.pmml.TableLocator;
import org.dmg.pmml.TextModel;
import org.dmg.pmml.TimeSeriesModel;
import org.dmg.pmml.TreeModel;
import org.dmg.pmml.VisitorAction;
import org.jpmml.evaluator.UnsupportedFeatureException;
import org.jpmml.evaluator.visitors.FeatureInspector;

public class UnsupportedFeatureInspector
extends FeatureInspector<UnsupportedFeatureException> {
    public VisitorAction visit(Aggregate aggregate) {
        Aggregate.Function function = aggregate.getFunction();
        switch (function) {
            case MULTISET: {
                this.report(new UnsupportedFeatureException((PMMLObject)aggregate, (Enum<?>)function));
                break;
            }
        }
        return super.visit(aggregate);
    }

    public VisitorAction visit(BaselineModel baselineModel) {
        this.report(new UnsupportedFeatureException((PMMLObject)baselineModel));
        return VisitorAction.SKIP;
    }

    public VisitorAction visit(CenterFields centerFields) {
        this.report(new UnsupportedFeatureException((PMMLObject)centerFields));
        return VisitorAction.SKIP;
    }

    public VisitorAction visit(ClusteringModel clusteringModel) {
        ClusteringModel.ModelClass modelClass = clusteringModel.getModelClass();
        switch (modelClass) {
            case DISTRIBUTION_BASED: {
                this.report(new UnsupportedFeatureException((PMMLObject)clusteringModel, (Enum<?>)modelClass));
                break;
            }
        }
        return super.visit(clusteringModel);
    }

    public VisitorAction visit(DecisionTree decisionTree) {
        this.report(new UnsupportedFeatureException((PMMLObject)decisionTree));
        return VisitorAction.SKIP;
    }

    public VisitorAction visit(NeuralNetwork neuralNetwork) {
        ActivationFunctionType activationFunction = neuralNetwork.getActivationFunction();
        switch (activationFunction) {
            case RADIAL_BASIS: {
                this.report(new UnsupportedFeatureException((PMMLObject)neuralNetwork, (Enum<?>)activationFunction));
                break;
            }
        }
        return super.visit(neuralNetwork);
    }

    public VisitorAction visit(NeuralLayer neuralLayer) {
        ActivationFunctionType activationFunction = neuralLayer.getActivationFunction();
        if (activationFunction != null) {
            switch (activationFunction) {
                case RADIAL_BASIS: {
                    this.report(new UnsupportedFeatureException((PMMLObject)neuralLayer, (Enum<?>)activationFunction));
                    break;
                }
            }
        }
        return super.visit(neuralLayer);
    }

    public VisitorAction visit(NormDiscrete normDiscrete) {
        NormDiscrete.Method method = normDiscrete.getMethod();
        switch (method) {
            case THERMOMETER: {
                this.report(new UnsupportedFeatureException((PMMLObject)normDiscrete, (Enum<?>)method));
                break;
            }
        }
        return super.visit(normDiscrete);
    }

    public VisitorAction visit(OutputField outputField) {
        FeatureType feature = outputField.getFeature();
        switch (feature) {
            case STANDARD_ERROR: {
                this.report(new UnsupportedFeatureException((PMMLObject)outputField, (Enum<?>)feature));
                break;
            }
        }
        return super.visit(outputField);
    }

    public VisitorAction visit(Predictor predictor) {
        Categories categories;
        Matrix matrix = predictor.getMatrix();
        if (matrix != null && (categories = predictor.getCategories()) == null) {
            this.report(new UnsupportedFeatureException((PMMLObject)predictor));
        }
        return super.visit(predictor);
    }

    public VisitorAction visit(Regression regression) {
        this.report(new UnsupportedFeatureException((PMMLObject)regression));
        return VisitorAction.SKIP;
    }

    public VisitorAction visit(Segmentation segmentation) {
        LocalTransformations localTransformations = segmentation.getLocalTransformations();
        if (localTransformations != null) {
            this.report(new UnsupportedFeatureException((PMMLObject)localTransformations));
        }
        return super.visit(segmentation);
    }

    public VisitorAction visit(SequenceModel sequenceModel) {
        this.report(new UnsupportedFeatureException((PMMLObject)sequenceModel));
        return VisitorAction.SKIP;
    }

    public VisitorAction visit(SupportVectorMachineModel supportVectorMachineModel) {
        SvmRepresentationType svmRepresentation = supportVectorMachineModel.getSvmRepresentation();
        switch (svmRepresentation) {
            case COEFFICIENTS: {
                this.report(new UnsupportedFeatureException((PMMLObject)supportVectorMachineModel, (Enum<?>)svmRepresentation));
                break;
            }
        }
        return super.visit(supportVectorMachineModel);
    }

    public VisitorAction visit(TableLocator tableLocator) {
        this.report(new UnsupportedFeatureException((PMMLObject)tableLocator));
        return VisitorAction.SKIP;
    }

    public VisitorAction visit(TextModel textModel) {
        this.report(new UnsupportedFeatureException((PMMLObject)textModel));
        return VisitorAction.SKIP;
    }

    public VisitorAction visit(TimeSeriesModel timeSeriesModel) {
        this.report(new UnsupportedFeatureException((PMMLObject)timeSeriesModel));
        return VisitorAction.SKIP;
    }

    public VisitorAction visit(TreeModel treeModel) {
        MissingValueStrategyType missingValueStrategy = treeModel.getMissingValueStrategy();
        switch (missingValueStrategy) {
            case AGGREGATE_NODES: 
            case WEIGHTED_CONFIDENCE: {
                this.report(new UnsupportedFeatureException((PMMLObject)treeModel, (Enum<?>)missingValueStrategy));
                break;
            }
        }
        return super.visit(treeModel);
    }
}

