/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.Arrays;
import org.dmg.pmml.DataType;
import org.dmg.pmml.OpType;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.OrdinalValue;
import org.junit.Assert;
import org.junit.Test;

public class FieldValueTest {
    @Test
    public void emptyList() {
        FieldValue list = FieldValueUtil.create(Arrays.asList(new Object[0]));
        Assert.assertEquals((Object)list.getDataType(), (Object)DataType.STRING);
        Assert.assertEquals((Object)list.getOpType(), (Object)OpType.CATEGORICAL);
    }

    @Test
    public void categoricalString() {
        FieldValue zero = FieldValueUtil.create((DataType)DataType.STRING, (OpType)OpType.CATEGORICAL, (Object)"0");
        FieldValue one = FieldValueUtil.create((DataType)DataType.STRING, (OpType)OpType.CATEGORICAL, (Object)"1");
        Assert.assertTrue((boolean)zero.equalsString("0"));
        Assert.assertFalse((boolean)zero.equalsString("0.0"));
        Assert.assertTrue((boolean)one.equalsString("1"));
        Assert.assertFalse((boolean)one.equalsString("1.0"));
        Assert.assertTrue((boolean)zero.equalsValue(zero));
        Assert.assertFalse((boolean)zero.equalsValue(one));
        Assert.assertFalse((boolean)one.equalsValue(zero));
        Assert.assertTrue((boolean)one.equalsValue(one));
        try {
            zero.compareToString("0");
            Assert.fail();
        }
        catch (EvaluationException ee) {
            // empty catch block
        }
        try {
            zero.compareTo(zero);
            Assert.fail();
        }
        catch (EvaluationException evaluationException) {
            // empty catch block
        }
        Assert.assertEquals((Object)0, (Object)zero.asInteger());
        Assert.assertEquals((Object)Boolean.FALSE, (Object)zero.asBoolean());
        Assert.assertEquals((Object)1, (Object)one.asInteger());
        Assert.assertEquals((Object)Boolean.TRUE, (Object)one.asBoolean());
    }

    @Test
    public void categoricalStringList() {
        FieldValue list = FieldValueUtil.create(Arrays.asList("1", "2", "3"));
        Assert.assertEquals((Object)DataType.STRING, (Object)list.getDataType());
        Assert.assertEquals((Object)OpType.CATEGORICAL, (Object)list.getOpType());
    }

    @Test
    public void ordinalString() {
        OrdinalValue loud = (OrdinalValue)FieldValueUtil.create((DataType)DataType.STRING, (OpType)OpType.ORDINAL, (Object)"loud");
        OrdinalValue louder = (OrdinalValue)FieldValueUtil.create((DataType)DataType.STRING, (OpType)OpType.ORDINAL, (Object)"louder");
        OrdinalValue insane = (OrdinalValue)FieldValueUtil.create((DataType)DataType.STRING, (OpType)OpType.ORDINAL, (Object)"insane");
        Assert.assertFalse((boolean)louder.equalsString("loud"));
        Assert.assertTrue((boolean)louder.equalsString("louder"));
        Assert.assertFalse((boolean)louder.equalsString("insane"));
        Assert.assertFalse((boolean)louder.equalsValue((FieldValue)loud));
        Assert.assertTrue((boolean)louder.equalsValue((FieldValue)louder));
        Assert.assertFalse((boolean)louder.equalsValue((FieldValue)insane));
        louder.setOrdering(null);
        Assert.assertTrue((louder.compareToString("loud") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((louder.compareToString("louder") == 0 ? 1 : 0) != 0);
        Assert.assertTrue((louder.compareToString("insane") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((louder.compareTo((FieldValue)loud) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((louder.compareTo((FieldValue)louder) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((louder.compareTo((FieldValue)insane) > 0 ? 1 : 0) != 0);
        louder.setOrdering(Arrays.asList(loud.getValue(), louder.getValue(), insane.getValue()));
        Assert.assertTrue((louder.compareToString("loud") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((louder.compareToString("louder") == 0 ? 1 : 0) != 0);
        Assert.assertTrue((louder.compareToString("insane") < 0 ? 1 : 0) != 0);
        Assert.assertTrue((louder.compareTo((FieldValue)loud) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((louder.compareTo((FieldValue)louder) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((louder.compareTo((FieldValue)insane) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void continuousInteger() {
        FieldValue zero = FieldValueUtil.create((DataType)DataType.INTEGER, (OpType)OpType.CONTINUOUS, (Object)0);
        FieldValue one = FieldValueUtil.create((DataType)DataType.INTEGER, (OpType)OpType.CONTINUOUS, (Object)1);
        Assert.assertTrue((boolean)zero.equalsString("-0"));
        Assert.assertTrue((boolean)zero.equalsString("-0.0"));
        Assert.assertTrue((boolean)zero.equalsString("0"));
        Assert.assertTrue((boolean)zero.equalsString("0.0"));
        Assert.assertTrue((boolean)zero.equalsString("false"));
        Assert.assertFalse((boolean)zero.equalsString("true"));
        Assert.assertTrue((boolean)one.equalsString("1"));
        Assert.assertTrue((boolean)one.equalsString("1.0"));
        Assert.assertFalse((boolean)one.equalsString("false"));
        Assert.assertTrue((boolean)one.equalsString("true"));
        Assert.assertTrue((boolean)zero.equalsValue(zero));
        Assert.assertFalse((boolean)zero.equalsValue(one));
        Assert.assertFalse((boolean)one.equalsValue(zero));
        Assert.assertTrue((boolean)one.equalsValue(one));
        Assert.assertTrue((zero.compareToString("-1") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((zero.compareToString("-1.5") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((zero.compareToString("-0") == 0 ? 1 : 0) != 0);
        Assert.assertTrue((zero.compareToString("-0.0") == 0 ? 1 : 0) != 0);
        Assert.assertTrue((zero.compareToString("0") == 0 ? 1 : 0) != 0);
        Assert.assertTrue((zero.compareToString("0.0") == 0 ? 1 : 0) != 0);
        Assert.assertTrue((zero.compareToString("1") < 0 ? 1 : 0) != 0);
        Assert.assertTrue((zero.compareToString("1.5") < 0 ? 1 : 0) != 0);
        Assert.assertTrue((zero.compareToString("false") == 0 ? 1 : 0) != 0);
        Assert.assertTrue((zero.compareToString("true") < 0 ? 1 : 0) != 0);
        Assert.assertTrue((one.compareToString("0") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((one.compareToString("1") == 0 ? 1 : 0) != 0);
        Assert.assertTrue((one.compareToString("1.0") == 0 ? 1 : 0) != 0);
        Assert.assertTrue((one.compareToString("2") < 0 ? 1 : 0) != 0);
        Assert.assertTrue((one.compareToString("false") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((one.compareToString("true") == 0 ? 1 : 0) != 0);
        Assert.assertTrue((zero.compareTo(zero) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((zero.compareTo(one) < 0 ? 1 : 0) != 0);
        try {
            FieldValue categoricalZero = FieldValueUtil.refine((DataType)zero.getDataType(), (OpType)OpType.CATEGORICAL, (FieldValue)zero);
            zero.compareTo(categoricalZero);
            Assert.fail();
        }
        catch (ClassCastException cce) {
            // empty catch block
        }
        try {
            FieldValue doubleZero = FieldValueUtil.refine((DataType)DataType.DOUBLE, (OpType)zero.getOpType(), (FieldValue)zero);
            zero.compareTo(doubleZero);
            Assert.fail();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        Assert.assertTrue((one.compareTo(zero) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((one.compareTo(one) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void continuousIntegerList() {
        FieldValue list = FieldValueUtil.create(Arrays.asList(1, 2, 3));
        Assert.assertEquals((Object)DataType.INTEGER, (Object)list.getDataType());
        Assert.assertEquals((Object)OpType.CONTINUOUS, (Object)list.getOpType());
    }

    @Test
    public void categoricalInteger() {
        FieldValue zero = FieldValueUtil.create((DataType)DataType.INTEGER, (OpType)OpType.CATEGORICAL, (Object)0);
        Assert.assertTrue((boolean)zero.equalsString("-0"));
        Assert.assertTrue((boolean)zero.equalsString("-0.0"));
        Assert.assertTrue((boolean)zero.equalsString("0"));
        Assert.assertTrue((boolean)zero.equalsString("0.0"));
        Assert.assertTrue((boolean)zero.equalsString("false"));
        Assert.assertFalse((boolean)zero.equalsString("true"));
        try {
            zero.compareToString("0");
            Assert.fail();
        }
        catch (EvaluationException ee) {
            // empty catch block
        }
        try {
            zero.compareTo(zero);
            Assert.fail();
        }
        catch (EvaluationException evaluationException) {
            // empty catch block
        }
    }

    @Test
    public void continuousFloat() {
        Float negativeZeroValue = Float.valueOf(-0.0f);
        Float positiveZeroValue = Float.valueOf(0.0f);
        Assert.assertTrue((negativeZeroValue.floatValue() == positiveZeroValue.floatValue() ? 1 : 0) != 0);
        Assert.assertFalse((boolean)negativeZeroValue.equals(positiveZeroValue));
        Assert.assertTrue((negativeZeroValue.compareTo(positiveZeroValue) < 0 ? 1 : 0) != 0);
        FieldValue negativeZero = FieldValueUtil.create((DataType)DataType.FLOAT, (OpType)OpType.CONTINUOUS, (Object)negativeZeroValue);
        FieldValue positiveZero = FieldValueUtil.create((DataType)DataType.FLOAT, (OpType)OpType.CONTINUOUS, (Object)positiveZeroValue);
        Assert.assertEquals((Object)negativeZero, (Object)positiveZero);
        Assert.assertTrue((boolean)negativeZero.equalsString("-0"));
        Assert.assertTrue((boolean)negativeZero.equalsString("-0.0"));
        Assert.assertTrue((boolean)negativeZero.equalsString("0"));
        Assert.assertTrue((boolean)negativeZero.equalsString("0.0"));
        Assert.assertTrue((boolean)negativeZero.equalsString("false"));
        Assert.assertTrue((negativeZero.compareToString("0") == 0 ? 1 : 0) != 0);
        Assert.assertTrue((negativeZero.compareToString("0.0") == 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)positiveZero.equalsString("-0"));
        Assert.assertTrue((boolean)positiveZero.equalsString("-0.0"));
        Assert.assertTrue((positiveZero.compareToString("-0") == 0 ? 1 : 0) != 0);
        Assert.assertTrue((positiveZero.compareToString("-0.0") == 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)negativeZero.equalsValue(positiveZero));
        Assert.assertTrue((negativeZero.compareTo(positiveZero) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void continuousDouble() {
        Double negativeZeroValue = -0.0;
        Double positiveZeroValue = 0.0;
        Assert.assertTrue((negativeZeroValue.doubleValue() == positiveZeroValue.doubleValue() ? 1 : 0) != 0);
        Assert.assertFalse((boolean)negativeZeroValue.equals(positiveZeroValue));
        Assert.assertTrue((negativeZeroValue.compareTo(positiveZeroValue) < 0 ? 1 : 0) != 0);
        FieldValue negativeZero = FieldValueUtil.create((DataType)DataType.DOUBLE, (OpType)OpType.CONTINUOUS, (Object)negativeZeroValue);
        FieldValue positiveZero = FieldValueUtil.create((DataType)DataType.DOUBLE, (OpType)OpType.CONTINUOUS, (Object)positiveZeroValue);
        Assert.assertEquals((Object)negativeZero, (Object)positiveZero);
        Assert.assertTrue((boolean)negativeZero.equalsString("-0"));
        Assert.assertTrue((boolean)negativeZero.equalsString("-0.0"));
        Assert.assertTrue((boolean)negativeZero.equalsString("0"));
        Assert.assertTrue((boolean)negativeZero.equalsString("0.0"));
        Assert.assertTrue((boolean)negativeZero.equalsString("false"));
        Assert.assertTrue((negativeZero.compareToString("0") == 0 ? 1 : 0) != 0);
        Assert.assertTrue((negativeZero.compareToString("0.0") == 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)positiveZero.equalsString("-0"));
        Assert.assertTrue((boolean)positiveZero.equalsString("-0.0"));
        Assert.assertTrue((positiveZero.compareToString("-0") == 0 ? 1 : 0) != 0);
        Assert.assertTrue((positiveZero.compareToString("-0.0") == 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)negativeZero.equalsValue(positiveZero));
        Assert.assertTrue((negativeZero.compareTo(positiveZero) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void categoricalBoolean() {
        FieldValue zero = FieldValueUtil.create((DataType)DataType.BOOLEAN, (OpType)OpType.CATEGORICAL, (Object)false);
        FieldValue one = FieldValueUtil.create((DataType)DataType.BOOLEAN, (OpType)OpType.CATEGORICAL, (Object)true);
        Assert.assertTrue((zero.compareToString("-0") == 0 ? 1 : 0) != 0);
        Assert.assertTrue((zero.compareToString("-0.0") == 0 ? 1 : 0) != 0);
        Assert.assertTrue((zero.compareToString("0") == 0 ? 1 : 0) != 0);
        Assert.assertTrue((zero.compareToString("0.0") == 0 ? 1 : 0) != 0);
        Assert.assertTrue((zero.compareToString("1") < 0 ? 1 : 0) != 0);
        Assert.assertTrue((zero.compareToString("1.0") < 0 ? 1 : 0) != 0);
        Assert.assertTrue((zero.compareToString("false") == 0 ? 1 : 0) != 0);
        Assert.assertTrue((zero.compareToString("true") < 0 ? 1 : 0) != 0);
        Assert.assertTrue((one.compareToString("0") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((one.compareToString("0.0") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((one.compareToString("1") == 0 ? 1 : 0) != 0);
        Assert.assertTrue((one.compareToString("1.0") == 0 ? 1 : 0) != 0);
        Assert.assertTrue((one.compareToString("false") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((one.compareToString("true") == 0 ? 1 : 0) != 0);
        Assert.assertTrue((zero.compareTo(zero) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((zero.compareTo(one) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((one.compareTo(zero) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((one.compareTo(one) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void categoricalDaysSinceDate() {
        FieldValue period = FieldValueUtil.create((DataType)DataType.DATE_DAYS_SINCE_1960, (OpType)OpType.CATEGORICAL, (Object)"1960-01-03");
        Assert.assertEquals((Object)2, (Object)period.asInteger());
    }

    @Test
    public void categoricalSecondsSinceDate() {
        FieldValue period = FieldValueUtil.create((DataType)DataType.DATE_TIME_SECONDS_SINCE_1960, (OpType)OpType.CATEGORICAL, (Object)"1960-01-03T03:30:03");
        Assert.assertEquals((Object)185403, (Object)period.asInteger());
    }
}

