/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.InputStream;
import java.util.List;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.PMML;
import org.jpmml.evaluator.Evaluator;
import org.jpmml.evaluator.EvaluatorUtil;
import org.jpmml.evaluator.ModelEvaluator;
import org.jpmml.evaluator.ModelEvaluatorFactory;
import org.jpmml.evaluator.PMMLManagerTest;
import org.junit.Assert;

public abstract class ModelEvaluatorTest
extends PMMLManagerTest {
    public ModelEvaluator<?> createModelEvaluator() throws Exception {
        return ModelEvaluatorTest.createModelEvaluator(this.getClass());
    }

    public ModelEvaluator<?> createModelEvaluator(ModelEvaluatorFactory modelEvaluatorFactory) throws Exception {
        return ModelEvaluatorTest.createModelEvaluator(this.getClass(), modelEvaluatorFactory);
    }

    public static ModelEvaluator<?> createModelEvaluator(Class<? extends ModelEvaluatorTest> clazz) throws Exception {
        return ModelEvaluatorTest.createModelEvaluator(clazz, ModelEvaluatorFactory.newInstance());
    }

    public static ModelEvaluator<?> createModelEvaluator(Class<? extends ModelEvaluatorTest> clazz, ModelEvaluatorFactory modelEvaluatorFactory) throws Exception {
        try (InputStream is = ModelEvaluatorTest.getInputStream(clazz);){
            ModelEvaluator<?> modelEvaluator = ModelEvaluatorTest.createModelEvaluator(is, modelEvaluatorFactory);
            return modelEvaluator;
        }
    }

    public static ModelEvaluator<?> createModelEvaluator(InputStream is, ModelEvaluatorFactory modelEvaluatorFactory) throws Exception {
        PMML pmml = ModelEvaluatorTest.loadPMML(is);
        Assert.assertNull((Object)pmml.getLocator());
        ModelEvaluator modelEvaluator = (ModelEvaluator)modelEvaluatorFactory.newModelManager(pmml);
        return modelEvaluator;
    }

    public static void checkResultFields(List<?> targetFields, List<?> outputFields, Evaluator evaluator) {
        Function<Object, FieldName> function = new Function<Object, FieldName>(){

            public FieldName apply(Object object) {
                return PMMLManagerTest.toFieldName(object);
            }
        };
        Assert.assertEquals((Object)Lists.transform(targetFields, (Function)function), (Object)EvaluatorUtil.getTargetFields((Evaluator)evaluator));
        Assert.assertEquals((Object)Lists.transform(outputFields, (Function)function), (Object)EvaluatorUtil.getOutputFields((Evaluator)evaluator));
    }
}

