/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.Arrays;
import java.util.List;
import org.dmg.pmml.Array;
import org.jpmml.evaluator.ArrayUtil;
import org.junit.Assert;
import org.junit.Test;

public class ArrayUtilTest {
    @Test
    public void parseIntArray() {
        Assert.assertEquals(Arrays.asList("1", "2", "3"), ArrayUtilTest.parseIntArray("1 2 3"));
    }

    @Test
    public void parseStringArray() {
        Assert.assertEquals(Arrays.asList("a"), ArrayUtilTest.parseStringArray("\"a\""));
        Assert.assertEquals(Arrays.asList("a", "b", "c"), ArrayUtilTest.parseStringArray("a b c"));
        Assert.assertEquals(Arrays.asList("a", "b", "c"), ArrayUtilTest.parseStringArray("\"a\" \"b\" \"c\""));
        Assert.assertEquals(Arrays.asList("a b c"), ArrayUtilTest.parseStringArray("\"a b c\""));
        Assert.assertEquals(Arrays.asList("\"a b c"), ArrayUtilTest.parseStringArray("\"a b c"));
        Assert.assertEquals(Arrays.asList("\\a", "\\b\\", "c\\"), ArrayUtilTest.parseStringArray("\\a \\b\\ c\\"));
        Assert.assertEquals(Arrays.asList("a \"b\" c"), ArrayUtilTest.parseStringArray("\"a \\\"b\\\" c\""));
        Assert.assertEquals(Arrays.asList("\"a b c\""), ArrayUtilTest.parseStringArray("\"\\\"a b c\\\"\""));
    }

    @Test
    public void intern() {
        List<String> left = ArrayUtilTest.parseStringArray("a b c");
        List<String> right = ArrayUtilTest.parseStringArray("\"a\" \"b\" \"c\"");
        for (int i = 0; i < 3; ++i) {
            Assert.assertSame((Object)left.get(i), (Object)right.get(i));
        }
    }

    private static List<String> parseIntArray(String content) {
        return ArrayUtil.parse((Array)new Array(Array.Type.INT, content));
    }

    private static List<String> parseStringArray(String content) {
        return ArrayUtil.parse((Array)new Array(Array.Type.STRING, content));
    }
}

