/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.List;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.Interval;
import org.dmg.pmml.InvalidValueTreatmentMethodType;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.OpType;
import org.dmg.pmml.OutlierTreatmentMethodType;
import org.dmg.pmml.Value;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.InvalidResultException;
import org.jpmml.evaluator.TypeCheckException;
import org.junit.Assert;
import org.junit.Test;

public class FieldValueUtilTest {
    @Test
    public void prepareContinuousInputValue() {
        FieldName name = FieldName.create((String)"x");
        DataField dataField = new DataField(name, OpType.CONTINUOUS, DataType.DOUBLE);
        MiningField miningField = new MiningField(name);
        Assert.assertEquals((Object)1.0, (Object)FieldValueUtilTest.prepare(dataField, miningField, "1"));
        Assert.assertEquals((Object)1.0, (Object)FieldValueUtilTest.prepare(dataField, miningField, 1));
        Assert.assertEquals((Object)1.0, (Object)FieldValueUtilTest.prepare(dataField, miningField, Float.valueOf(1.0f)));
        Assert.assertEquals((Object)1.0, (Object)FieldValueUtilTest.prepare(dataField, miningField, 1.0));
        try {
            FieldValueUtilTest.prepare(dataField, miningField, "one");
            Assert.fail();
        }
        catch (InvalidResultException ire) {
            // empty catch block
        }
        miningField.setInvalidValueTreatment(InvalidValueTreatmentMethodType.AS_IS);
        try {
            FieldValueUtilTest.prepare(dataField, miningField, "one");
            Assert.fail();
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        Value missingValue = FieldValueUtilTest.createValue("N/A", Value.Property.MISSING);
        dataField.addValues(new Value[]{missingValue});
        miningField.setInvalidValueTreatment(InvalidValueTreatmentMethodType.AS_MISSING);
        Assert.assertEquals(null, (Object)FieldValueUtilTest.prepare(dataField, miningField, null));
        Assert.assertEquals(null, (Object)FieldValueUtilTest.prepare(dataField, miningField, "N/A"));
        Assert.assertEquals(null, (Object)FieldValueUtilTest.prepare(dataField, miningField, "one"));
        miningField.setMissingValueReplacement("0");
        Assert.assertEquals((Object)0.0, (Object)FieldValueUtilTest.prepare(dataField, miningField, null));
        Assert.assertEquals((Object)0.0, (Object)FieldValueUtilTest.prepare(dataField, miningField, "N/A"));
        Assert.assertEquals((Object)0.0, (Object)FieldValueUtilTest.prepare(dataField, miningField, "one"));
        miningField.setOutlierTreatment(OutlierTreatmentMethodType.AS_IS).setLowValue(Double.valueOf(1.0)).setHighValue(Double.valueOf(3.0));
        Assert.assertEquals((Object)-1.0, (Object)FieldValueUtilTest.prepare(dataField, miningField, -1.0));
        Assert.assertEquals((Object)1.0, (Object)FieldValueUtilTest.prepare(dataField, miningField, 1.0));
        Assert.assertEquals((Object)5.0, (Object)FieldValueUtilTest.prepare(dataField, miningField, 5.0));
        miningField.setOutlierTreatment(OutlierTreatmentMethodType.AS_MISSING_VALUES);
        Assert.assertEquals((Object)0.0, (Object)FieldValueUtilTest.prepare(dataField, miningField, -1.0));
        Assert.assertEquals((Object)1.0, (Object)FieldValueUtilTest.prepare(dataField, miningField, 1.0));
        Assert.assertEquals((Object)0.0, (Object)FieldValueUtilTest.prepare(dataField, miningField, 5.0));
        miningField.setOutlierTreatment(OutlierTreatmentMethodType.AS_EXTREME_VALUES);
        Assert.assertEquals((Object)1.0, (Object)FieldValueUtilTest.prepare(dataField, miningField, -1.0));
        Assert.assertEquals((Object)1.0, (Object)FieldValueUtilTest.prepare(dataField, miningField, 1.0));
        Assert.assertEquals((Object)3.0, (Object)FieldValueUtilTest.prepare(dataField, miningField, 5.0));
        miningField.setOutlierTreatment(null).setLowValue(null).setHighValue(null);
        Interval validInterval = new Interval(Interval.Closure.CLOSED_CLOSED).setLeftMargin(Double.valueOf(1.0)).setRightMargin(Double.valueOf(3.0));
        dataField.addIntervals(new Interval[]{validInterval});
        miningField.setInvalidValueTreatment(InvalidValueTreatmentMethodType.RETURN_INVALID);
        try {
            FieldValueUtilTest.prepare(dataField, miningField, -1.0);
            Assert.fail();
        }
        catch (InvalidResultException ire) {
            // empty catch block
        }
        Assert.assertEquals((Object)1.0, (Object)FieldValueUtilTest.prepare(dataField, miningField, 1.0));
        try {
            FieldValueUtilTest.prepare(dataField, miningField, 5.0);
            Assert.fail();
        }
        catch (InvalidResultException ire) {
            // empty catch block
        }
        miningField.setInvalidValueTreatment(InvalidValueTreatmentMethodType.AS_MISSING);
        Assert.assertEquals((Object)0.0, (Object)FieldValueUtilTest.prepare(dataField, miningField, -1.0));
        Assert.assertEquals((Object)1.0, (Object)FieldValueUtilTest.prepare(dataField, miningField, 1.0));
        Assert.assertEquals((Object)0.0, (Object)FieldValueUtilTest.prepare(dataField, miningField, 5.0));
        FieldValueUtilTest.clearIntervalsAndValues(dataField);
        dataField.addValues(new Value[]{missingValue, FieldValueUtilTest.createValue("1", Value.Property.VALID), FieldValueUtilTest.createValue("2", Value.Property.VALID), FieldValueUtilTest.createValue("3", Value.Property.VALID)});
        miningField.setInvalidValueTreatment(InvalidValueTreatmentMethodType.AS_IS);
        Assert.assertEquals((Object)1.0, (Object)FieldValueUtilTest.prepare(dataField, miningField, 1.0));
        Assert.assertEquals((Object)5.0, (Object)FieldValueUtilTest.prepare(dataField, miningField, 5.0));
        miningField.setInvalidValueTreatment(InvalidValueTreatmentMethodType.AS_MISSING);
        Assert.assertEquals((Object)1.0, (Object)FieldValueUtilTest.prepare(dataField, miningField, 1.0));
        Assert.assertEquals((Object)0.0, (Object)FieldValueUtilTest.prepare(dataField, miningField, 5.0));
        FieldValueUtilTest.clearIntervalsAndValues(dataField);
        dataField.addValues(new Value[]{missingValue, FieldValueUtilTest.createValue("1", Value.Property.INVALID)});
        miningField.setInvalidValueTreatment(InvalidValueTreatmentMethodType.AS_IS);
        Assert.assertEquals((Object)1.0, (Object)FieldValueUtilTest.prepare(dataField, miningField, 1.0));
        Assert.assertEquals((Object)5.0, (Object)FieldValueUtilTest.prepare(dataField, miningField, 5.0));
        miningField.setInvalidValueTreatment(InvalidValueTreatmentMethodType.AS_MISSING);
        Assert.assertEquals((Object)0.0, (Object)FieldValueUtilTest.prepare(dataField, miningField, 1.0));
        Assert.assertEquals((Object)5.0, (Object)FieldValueUtilTest.prepare(dataField, miningField, 5.0));
    }

    @Test
    public void prepareCategoricalInputValue() {
        FieldName name = FieldName.create((String)"x");
        DataField dataField = new DataField(name, OpType.CATEGORICAL, DataType.INTEGER);
        MiningField miningField = new MiningField(name);
        Assert.assertEquals((Object)1, (Object)FieldValueUtilTest.prepare(dataField, miningField, "1"));
        Assert.assertEquals((Object)1, (Object)FieldValueUtilTest.prepare(dataField, miningField, 1));
        try {
            FieldValueUtilTest.prepare(dataField, miningField, "one");
            Assert.fail();
        }
        catch (InvalidResultException ire) {
            // empty catch block
        }
        try {
            FieldValueUtilTest.prepare(dataField, miningField, 1.5);
            Assert.fail();
        }
        catch (InvalidResultException ire) {
            // empty catch block
        }
        miningField.setInvalidValueTreatment(InvalidValueTreatmentMethodType.AS_IS);
        try {
            FieldValueUtilTest.prepare(dataField, miningField, "one");
            Assert.fail();
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        try {
            FieldValueUtilTest.prepare(dataField, miningField, 1.5);
            Assert.fail();
        }
        catch (TypeCheckException tce) {
            // empty catch block
        }
        Value missingValue = FieldValueUtilTest.createValue("-999", Value.Property.MISSING);
        dataField.addValues(new Value[]{missingValue});
        miningField.setInvalidValueTreatment(InvalidValueTreatmentMethodType.AS_MISSING);
        Assert.assertEquals(null, (Object)FieldValueUtilTest.prepare(dataField, miningField, null));
        Assert.assertEquals(null, (Object)FieldValueUtilTest.prepare(dataField, miningField, "-999"));
        Assert.assertEquals(null, (Object)FieldValueUtilTest.prepare(dataField, miningField, -999));
        Assert.assertEquals(null, (Object)FieldValueUtilTest.prepare(dataField, miningField, "one"));
        Assert.assertEquals(null, (Object)FieldValueUtilTest.prepare(dataField, miningField, 1.5));
        miningField.setMissingValueReplacement("0");
        Assert.assertEquals((Object)0, (Object)FieldValueUtilTest.prepare(dataField, miningField, null));
        Assert.assertEquals((Object)0, (Object)FieldValueUtilTest.prepare(dataField, miningField, "-999"));
        Assert.assertEquals((Object)0, (Object)FieldValueUtilTest.prepare(dataField, miningField, -999));
        Assert.assertEquals((Object)0, (Object)FieldValueUtilTest.prepare(dataField, miningField, "one"));
        Assert.assertEquals((Object)0, (Object)FieldValueUtilTest.prepare(dataField, miningField, 1.5));
    }

    private static Object prepare(DataField dataField, MiningField miningField, Object value) {
        FieldValue result = FieldValueUtil.prepareInputValue((DataField)dataField, (MiningField)miningField, (Object)value);
        return FieldValueUtil.getValue((FieldValue)result);
    }

    private static void clearIntervalsAndValues(DataField dataField) {
        List intervals = dataField.getIntervals();
        intervals.clear();
        List values = dataField.getValues();
        values.clear();
    }

    private static Value createValue(String value, Value.Property property) {
        Value result = new Value(value).setProperty(property);
        return result;
    }
}

