/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.Collections;
import java.util.List;
import org.dmg.pmml.Apply;
import org.dmg.pmml.FieldName;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.ExpressionUtil;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.FunctionUtil;
import org.jpmml.evaluator.PMMLEvaluationContext;
import org.jpmml.evaluator.PMMLManager;
import org.jpmml.evaluator.PMMLManagerTest;
import org.junit.Assert;
import org.junit.Test;

public class DefineFunctionTest
extends PMMLManagerTest {
    @Test
    public void evaluateAmPm() throws Exception {
        PMMLManager pmmlManager = this.createPMMLManager();
        PMMLEvaluationContext context = new PMMLEvaluationContext(pmmlManager);
        DefineFunctionTest.assertValueEquals("AM", DefineFunctionTest.evaluateAmPm(34742, (EvaluationContext)context));
        context.declareAll(DefineFunctionTest.createArguments("StartTime", 34742));
        DefineFunctionTest.assertValueEquals("AM", DefineFunctionTest.evaluateField(new FieldName("Shift"), (EvaluationContext)context));
    }

    @Test
    public void evaluateStategroup() throws Exception {
        PMMLManager pmmlManager = this.createPMMLManager();
        PMMLEvaluationContext context = new PMMLEvaluationContext(pmmlManager);
        DefineFunctionTest.assertValueEquals("West", DefineFunctionTest.evaluateStategroup("CA", (EvaluationContext)context));
        DefineFunctionTest.assertValueEquals("West", DefineFunctionTest.evaluateStategroup("OR", (EvaluationContext)context));
        DefineFunctionTest.assertValueEquals("East", DefineFunctionTest.evaluateStategroup("NC", (EvaluationContext)context));
        context.declareAll(DefineFunctionTest.createArguments("State", "CA"));
        DefineFunctionTest.assertValueEquals("West", DefineFunctionTest.evaluateField(new FieldName("Group"), (EvaluationContext)context));
    }

    private static void assertValueEquals(Object expected, FieldValue actual) {
        Assert.assertEquals((Object)expected, (Object)FieldValueUtil.getValue((FieldValue)actual));
    }

    private static FieldValue evaluateAmPm(Integer time, EvaluationContext context) {
        List<FieldValue> values = Collections.singletonList(FieldValueUtil.create((Object)time));
        return DefineFunctionTest.evaluateFunction("AMPM", values, context);
    }

    private static FieldValue evaluateStategroup(String state, EvaluationContext context) {
        List<FieldValue> values = Collections.singletonList(FieldValueUtil.create((Object)state));
        return DefineFunctionTest.evaluateFunction("STATEGROUP", values, context);
    }

    private static FieldValue evaluateField(FieldName name, EvaluationContext context) {
        return ExpressionUtil.evaluate((FieldName)name, (EvaluationContext)context);
    }

    private static FieldValue evaluateFunction(String function, List<FieldValue> values, EvaluationContext context) {
        Apply apply = new Apply(function);
        return FunctionUtil.evaluate((Apply)apply, values, (EvaluationContext)context);
    }
}

