/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.Model;
import org.dmg.pmml.OpType;
import org.dmg.pmml.Output;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.PMML;
import org.dmg.pmml.ResultFeatureType;
import org.jpmml.evaluator.EvaluatorUtil;
import org.jpmml.evaluator.ModelEvaluator;
import org.jpmml.evaluator.ModelEvaluatorTest;
import org.jpmml.evaluator.StandardAssociationSchemaTest;
import org.junit.Assert;
import org.junit.Test;

public class ModelEvaluationContextTest
extends ModelEvaluatorTest {
    @Test
    public void evaluate() throws Exception {
        ModelEvaluator<?> evaluator = ModelEvaluationContextTest.createModelEvaluator(StandardAssociationSchemaTest.class);
        FieldName item = new FieldName("item");
        List<String> itemValue = Arrays.asList("Cracker", "Water", "Coke");
        FieldName dummy = new FieldName("dummy");
        String dummyValue = "Dummy";
        PMML pmml = evaluator.getPMML();
        DataDictionary dataDictionary = pmml.getDataDictionary().addDataFields(new DataField[]{new DataField(dummy, OpType.CATEGORICAL, DataType.STRING)});
        Model model = evaluator.getModel();
        Output output = model.getOutput().addOutputFields(new OutputField[]{ModelEvaluationContextTest.createArgumentCopy(item, null), ModelEvaluationContextTest.createArgumentCopy(dummy, "missing")});
        Map<FieldName, ?> arguments = ModelEvaluationContextTest.createArguments(item, EvaluatorUtil.prepare(evaluator, (FieldName)item, itemValue), dummy, dummyValue);
        Map result = evaluator.evaluate(arguments);
        Assert.assertEquals(itemValue, result.get(new FieldName("item_copy")));
        Assert.assertEquals((Object)"missing", result.get(new FieldName("dummy_copy")));
    }

    private static OutputField createArgumentCopy(FieldName name, String mapMissingTo) {
        FieldRef fieldRef = new FieldRef(name).setMapMissingTo(mapMissingTo);
        OutputField result = new OutputField().setName(FieldName.create((String)(name.getValue() + "_copy"))).setFeature(ResultFeatureType.TRANSFORMED_VALUE).setExpression((Expression)fieldRef);
        return result;
    }
}

