/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import java.util.List;
import java.util.Set;
import org.dmg.pmml.Cluster;
import org.jpmml.evaluator.Classification;
import org.jpmml.evaluator.EntityClassification;
import org.jpmml.evaluator.HasAffinityRanking;
import org.jpmml.evaluator.HasDisplayValue;
import org.jpmml.evaluator.HasEntityAffinity;
import org.jpmml.evaluator.HasEntityIdRanking;

public class ClusterAffinityDistribution
extends EntityClassification<Cluster>
implements HasEntityIdRanking,
HasDisplayValue,
HasAffinityRanking,
HasEntityAffinity {
    protected ClusterAffinityDistribution(Classification.Type type, BiMap<String, Cluster> entityRegistry) {
        super(type, entityRegistry);
        Preconditions.checkArgument((Classification.Type.DISTANCE.equals(type) || Classification.Type.SIMILARITY.equals(type) ? 1 : 0) != 0);
    }

    @Override
    public Set<String> getCategoryValues() {
        return this.keySet();
    }

    @Override
    public List<String> getEntityIdRanking() {
        return this.getWinnerKeys();
    }

    @Override
    public String getDisplayValue() {
        Cluster cluster = (Cluster)this.getEntity();
        return cluster.getName();
    }

    @Override
    public Double getAffinity(String value) {
        return this.get(value);
    }

    @Override
    public List<Double> getAffinityRanking() {
        return this.getWinnerValues();
    }

    @Override
    public Double getEntityAffinity() {
        return this.getAffinity(this.getEntityId());
    }
}

