/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.PMMLObject;
import org.jpmml.evaluator.DuplicateFieldException;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;

public abstract class EvaluationContext {
    private Map<FieldName, FieldValue> fields = new LinkedHashMap<FieldName, FieldValue>();
    private List<String> warnings = new ArrayList<String>();

    public abstract Result<DerivedField> resolveDerivedField(FieldName var1);

    public abstract Result<DefineFunction> resolveFunction(String var1);

    public FieldValue getField(FieldName name) {
        Map.Entry<FieldName, FieldValue> entry = this.getFieldEntry(name);
        if (entry != null) {
            return entry.getValue();
        }
        return null;
    }

    public Map.Entry<FieldName, FieldValue> getFieldEntry(FieldName name) {
        Map<FieldName, FieldValue> fields = this.getFields();
        if (fields.containsKey(name)) {
            AbstractMap.SimpleEntry<FieldName, FieldValue> entry = new AbstractMap.SimpleEntry<FieldName, FieldValue>(name, fields.get(name));
            return entry;
        }
        return null;
    }

    public void declare(FieldName name, Object value) {
        if (value instanceof FieldValue) {
            this.declare(name, (FieldValue)value);
            return;
        }
        this.declare(name, this.createFieldValue(name, value));
    }

    public void declare(FieldName name, FieldValue value) {
        Map<FieldName, FieldValue> fields = this.getFields();
        boolean declared = fields.containsKey(name);
        if (declared) {
            throw new DuplicateFieldException(name);
        }
        fields.put(name, value);
    }

    public void declareAll(Map<FieldName, ?> fields) {
        this.declareAll(fields.keySet(), fields);
    }

    public void declareAll(Collection<FieldName> names, Map<FieldName, ?> fields) {
        for (FieldName name : names) {
            this.declare(name, fields.get(name));
        }
    }

    public FieldValue createFieldValue(FieldName name, Object value) {
        return FieldValueUtil.create(value);
    }

    public void addWarning(String warning) {
        List<String> warnings = this.getWarnings();
        warnings.add(warning);
    }

    public Map<FieldName, FieldValue> getFields() {
        return this.fields;
    }

    public List<String> getWarnings() {
        return this.warnings;
    }

    <E extends PMMLObject> Result<E> createResult(E element) {
        if (element != null) {
            return new Result(this, element);
        }
        return null;
    }

    public static class Result<E extends PMMLObject> {
        private E element = null;
        final /* synthetic */ EvaluationContext this$0;

        Result(E element) {
            this.this$0 = var1_1;
            this.setElement(element);
        }

        public EvaluationContext getContext() {
            return this.this$0;
        }

        public E getElement() {
            return this.element;
        }

        private void setElement(E element) {
            this.element = element;
        }
    }
}

