/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.Aggregate;
import org.dmg.pmml.Apply;
import org.dmg.pmml.Constant;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Discretize;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldColumnPair;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.InvalidValueTreatmentMethodType;
import org.dmg.pmml.MapValues;
import org.dmg.pmml.NormContinuous;
import org.dmg.pmml.NormDiscrete;
import org.dmg.pmml.PMMLObject;
import org.jpmml.evaluator.DiscretizationUtil;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.FunctionUtil;
import org.jpmml.evaluator.Functions;
import org.jpmml.evaluator.InvalidResultException;
import org.jpmml.evaluator.ModelEvaluator;
import org.jpmml.evaluator.NormalizationUtil;
import org.jpmml.evaluator.TypeAnalysisException;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.UnsupportedFeatureException;

public class ExpressionUtil {
    private ExpressionUtil() {
    }

    public static FieldValue evaluate(FieldName name, EvaluationContext context) {
        Map.Entry<FieldName, FieldValue> entry = context.getFieldEntry(name);
        if (entry != null) {
            return entry.getValue();
        }
        EvaluationContext.Result<DerivedField> result = context.resolveDerivedField(name);
        if (result != null) {
            FieldValue value = ExpressionUtil.evaluate(result.getElement(), context);
            context.declare(name, value);
            EvaluationContext resultContext = result.getContext();
            if (!resultContext.equals(context)) {
                resultContext.declare(name, value);
            }
            return value;
        }
        return null;
    }

    public static FieldValue evaluate(DerivedField derivedField, EvaluationContext context) {
        FieldValue value = ExpressionUtil.evaluate(derivedField.getExpression(), context);
        return FieldValueUtil.refine((Field)derivedField, value);
    }

    public static FieldValue evaluate(Expression expression, EvaluationContext context) {
        if (expression instanceof Constant) {
            return ExpressionUtil.evaluateConstant((Constant)expression, context);
        }
        if (expression instanceof FieldRef) {
            return ExpressionUtil.evaluateFieldRef((FieldRef)expression, context);
        }
        if (expression instanceof NormContinuous) {
            return ExpressionUtil.evaluateNormContinuous((NormContinuous)expression, context);
        }
        if (expression instanceof NormDiscrete) {
            return ExpressionUtil.evaluateNormDiscrete((NormDiscrete)expression, context);
        }
        if (expression instanceof Discretize) {
            return ExpressionUtil.evaluateDiscretize((Discretize)expression, context);
        }
        if (expression instanceof MapValues) {
            return ExpressionUtil.evaluateMapValues((MapValues)expression, context);
        }
        if (expression instanceof Apply) {
            return ExpressionUtil.evaluateApply((Apply)expression, context);
        }
        if (expression instanceof Aggregate) {
            return ExpressionUtil.evaluateAggregate((Aggregate)expression, context);
        }
        throw new UnsupportedFeatureException((PMMLObject)expression);
    }

    public static DataType getDataType(Expression expression, ModelEvaluator<?> modelEvaluator) {
        if (expression instanceof Constant) {
            Constant constant = (Constant)expression;
            String value = constant.getValue();
            DataType dataType = constant.getDataType();
            if (dataType == null) {
                dataType = TypeUtil.getConstantDataType(value);
            }
            return dataType;
        }
        if (expression instanceof FieldRef) {
            FieldRef fieldRef = (FieldRef)expression;
            FieldName name = fieldRef.getField();
            DataField dataField = modelEvaluator.getDataField(name);
            if (dataField != null) {
                return dataField.getDataType();
            }
            DerivedField derivedField = modelEvaluator.resolveDerivedField(name);
            if (derivedField != null) {
                return derivedField.getDataType();
            }
            throw new TypeAnalysisException((PMMLObject)expression);
        }
        if (expression instanceof NormContinuous) {
            return DataType.DOUBLE;
        }
        if (expression instanceof NormDiscrete) {
            return DataType.DOUBLE;
        }
        if (expression instanceof Discretize) {
            Discretize discretize = (Discretize)expression;
            DataType dataType = discretize.getDataType();
            if (dataType == null) {
                dataType = DataType.STRING;
            }
            return dataType;
        }
        if (expression instanceof MapValues) {
            MapValues mapValues = (MapValues)expression;
            DataType dataType = mapValues.getDataType();
            if (dataType == null) {
                dataType = DataType.STRING;
            }
            return dataType;
        }
        if (expression instanceof Apply) {
            throw new TypeAnalysisException((PMMLObject)expression);
        }
        if (expression instanceof Aggregate) {
            throw new TypeAnalysisException((PMMLObject)expression);
        }
        throw new UnsupportedFeatureException((PMMLObject)expression);
    }

    public static FieldValue evaluateConstant(Constant constant, EvaluationContext context) {
        String value = constant.getValue();
        DataType dataType = constant.getDataType();
        if (dataType == null) {
            dataType = TypeUtil.getConstantDataType(value);
        }
        return FieldValueUtil.create(dataType, null, (Object)value);
    }

    public static FieldValue evaluateFieldRef(FieldRef fieldRef, EvaluationContext context) {
        FieldValue value = ExpressionUtil.evaluate(fieldRef.getField(), context);
        if (value == null) {
            return FieldValueUtil.create(fieldRef.getMapMissingTo());
        }
        return value;
    }

    public static FieldValue evaluateNormContinuous(NormContinuous normContinuous, EvaluationContext context) {
        FieldValue value = ExpressionUtil.evaluate(normContinuous.getField(), context);
        if (value == null) {
            return FieldValueUtil.create(normContinuous.getMapMissingTo());
        }
        return NormalizationUtil.normalize(normContinuous, value);
    }

    public static FieldValue evaluateNormDiscrete(NormDiscrete normDiscrete, EvaluationContext context) {
        FieldValue value = ExpressionUtil.evaluate(normDiscrete.getField(), context);
        if (value == null) {
            return FieldValueUtil.create(normDiscrete.getMapMissingTo());
        }
        NormDiscrete.Method method = normDiscrete.getMethod();
        switch (method) {
            case INDICATOR: {
                boolean equals = value.equalsString(normDiscrete.getValue());
                return FieldValueUtil.create(equals ? 1.0 : 0.0);
            }
        }
        throw new UnsupportedFeatureException((PMMLObject)normDiscrete, (Enum<?>)method);
    }

    public static FieldValue evaluateDiscretize(Discretize discretize, EvaluationContext context) {
        FieldValue value = ExpressionUtil.evaluate(discretize.getField(), context);
        if (value == null) {
            return FieldValueUtil.create(discretize.getDataType(), null, (Object)discretize.getMapMissingTo());
        }
        return DiscretizationUtil.discretize(discretize, value);
    }

    public static FieldValue evaluateMapValues(MapValues mapValues, EvaluationContext context) {
        LinkedHashMap<String, FieldValue> values = new LinkedHashMap<String, FieldValue>();
        List fieldColumnPairs = mapValues.getFieldColumnPairs();
        for (FieldColumnPair fieldColumnPair : fieldColumnPairs) {
            FieldValue value = ExpressionUtil.evaluate(fieldColumnPair.getField(), context);
            if (value == null) {
                return FieldValueUtil.create(mapValues.getDataType(), null, (Object)mapValues.getMapMissingTo());
            }
            values.put(fieldColumnPair.getColumn(), value);
        }
        return DiscretizationUtil.mapValue(mapValues, values);
    }

    public static FieldValue evaluateApply(Apply apply, EvaluationContext context) {
        FieldValue result;
        String mapMissingTo = apply.getMapMissingTo();
        List expressions = apply.getExpressions();
        Iterator arguments = expressions.iterator();
        ArrayList<FieldValue> values = new ArrayList<FieldValue>();
        String name = apply.getFunction();
        if ("if".equals(name) && arguments.hasNext()) {
            FieldValue flag = ExpressionUtil.evaluate((Expression)arguments.next(), context);
            if (flag == null && mapMissingTo != null) {
                return FieldValueUtil.create(mapMissingTo);
            }
            values.add(flag);
            if (flag == null) {
                if (arguments.hasNext()) {
                    arguments.next();
                    values.add(null);
                    if (arguments.hasNext()) {
                        arguments.next();
                        values.add(null);
                    }
                }
            } else if (flag.asBoolean().booleanValue()) {
                if (arguments.hasNext()) {
                    FieldValue trueValue = ExpressionUtil.evaluate((Expression)arguments.next(), context);
                    if (trueValue == null && mapMissingTo != null) {
                        return FieldValueUtil.create(mapMissingTo);
                    }
                    values.add(trueValue);
                    if (arguments.hasNext()) {
                        arguments.next();
                        values.add(null);
                    }
                }
            } else if (arguments.hasNext()) {
                arguments.next();
                values.add(null);
                if (arguments.hasNext()) {
                    FieldValue falseValue = ExpressionUtil.evaluate((Expression)arguments.next(), context);
                    if (falseValue == null && mapMissingTo != null) {
                        return FieldValueUtil.create(mapMissingTo);
                    }
                    values.add(falseValue);
                }
            }
        }
        while (arguments.hasNext()) {
            FieldValue value = ExpressionUtil.evaluate((Expression)arguments.next(), context);
            if (value == null && mapMissingTo != null) {
                return FieldValueUtil.create(mapMissingTo);
            }
            values.add(value);
        }
        String defaultValue = apply.getDefaultValue();
        try {
            result = FunctionUtil.evaluate(apply, values, context);
        }
        catch (InvalidResultException ire) {
            InvalidValueTreatmentMethodType invalidValueTreatmentMethod = apply.getInvalidValueTreatment();
            switch (invalidValueTreatmentMethod) {
                case RETURN_INVALID: {
                    throw new InvalidResultException((PMMLObject)apply);
                }
                case AS_IS: {
                    throw ire;
                }
                case AS_MISSING: {
                    return FieldValueUtil.create(defaultValue);
                }
            }
            throw new UnsupportedFeatureException((PMMLObject)apply, (Enum<?>)invalidValueTreatmentMethod);
        }
        if (result == null && defaultValue != null) {
            return FieldValueUtil.create(defaultValue);
        }
        return result;
    }

    public static FieldValue evaluateAggregate(Aggregate aggregate, EvaluationContext context) {
        FieldValue value = ExpressionUtil.evaluate(aggregate.getField(), context);
        Collection values = FieldValueUtil.getValue(Collection.class, value);
        FieldName groupName = aggregate.getGroupField();
        if (groupName != null) {
            FieldValue groupValue = ExpressionUtil.evaluate(groupName, context);
            TypeUtil.getDataType(FieldValueUtil.getValue(groupValue));
        }
        values = Lists.newArrayList((Iterable)Iterables.filter((Iterable)values, (Predicate)Predicates.notNull()));
        Aggregate.Function function = aggregate.getFunction();
        switch (function) {
            case COUNT: {
                return FieldValueUtil.create(values.size());
            }
            case SUM: {
                return Functions.SUM.evaluate(FieldValueUtil.createAll((List)values));
            }
            case AVERAGE: {
                return Functions.AVG.evaluate(FieldValueUtil.createAll((List)values));
            }
            case MIN: {
                return FieldValueUtil.create(Collections.min((List)values));
            }
            case MAX: {
                return FieldValueUtil.create(Collections.max((List)values));
            }
        }
        throw new UnsupportedFeatureException((PMMLObject)aggregate, (Enum<?>)function);
    }
}

