/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldUsageType;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.MiningFunctionType;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.Output;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Target;
import org.dmg.pmml.Targets;
import org.jpmml.evaluator.Consumer;
import org.jpmml.evaluator.InvalidFeatureException;
import org.jpmml.evaluator.PMMLManager;

public class ModelManager<M extends Model>
extends PMMLManager
implements Consumer {
    private M model = null;
    private static final EnumSet<FieldUsageType> ACTIVE_SET = EnumSet.of(FieldUsageType.ACTIVE);
    private static final EnumSet<FieldUsageType> GROUP_SET = EnumSet.of(FieldUsageType.GROUP);
    private static final EnumSet<FieldUsageType> ORDER_SET = EnumSet.of(FieldUsageType.ORDER);
    private static final EnumSet<FieldUsageType> TARGET_SET = EnumSet.of(FieldUsageType.PREDICTED, FieldUsageType.TARGET);

    public ModelManager(PMML pmml, M model) {
        super(pmml);
        this.setModel((Model)Preconditions.checkNotNull(model));
        MiningSchema miningSchema = model.getMiningSchema();
        if (miningSchema == null) {
            throw new InvalidFeatureException((PMMLObject)model);
        }
    }

    @Override
    public String getSummary() {
        return null;
    }

    @Override
    public MiningFunctionType getMiningFunction() {
        M model = this.getModel();
        return model.getFunctionName();
    }

    @Override
    public List<FieldName> getActiveFields() {
        return this.getMiningFields(ACTIVE_SET);
    }

    @Override
    public List<FieldName> getGroupFields() {
        return this.getMiningFields(GROUP_SET);
    }

    @Override
    public List<FieldName> getOrderFields() {
        return this.getMiningFields(ORDER_SET);
    }

    @Override
    public List<FieldName> getTargetFields() {
        return this.getMiningFields(TARGET_SET);
    }

    @Override
    public FieldName getTargetField() {
        M model = this.getModel();
        List<FieldName> targetFields = this.getTargetFields();
        if (targetFields.size() < 1) {
            return null;
        }
        if (targetFields.size() > 1) {
            MiningSchema miningSchema = model.getMiningSchema();
            throw new InvalidFeatureException("Too many target fields", (PMMLObject)miningSchema);
        }
        return targetFields.get(0);
    }

    @Override
    public MiningField getMiningField(FieldName name) {
        M model = this.getModel();
        MiningSchema miningSchema = model.getMiningSchema();
        return (MiningField)ModelManager.find(miningSchema.getMiningFields(), name);
    }

    protected List<FieldName> getMiningFields(EnumSet<FieldUsageType> fieldUsageTypes) {
        M model = this.getModel();
        MiningSchema miningSchema = model.getMiningSchema();
        ArrayList<FieldName> result = new ArrayList<FieldName>();
        List miningFields = miningSchema.getMiningFields();
        for (MiningField miningField : miningFields) {
            FieldUsageType fieldUsageType = miningField.getUsageType();
            if (!fieldUsageTypes.contains(fieldUsageType)) continue;
            result.add(miningField.getName());
        }
        return result;
    }

    public DerivedField getLocalDerivedField(FieldName name) {
        M model = this.getModel();
        LocalTransformations localTransformations = model.getLocalTransformations();
        if (localTransformations == null || !localTransformations.hasDerivedFields()) {
            return null;
        }
        return (DerivedField)ModelManager.find(localTransformations.getDerivedFields(), name);
    }

    public DerivedField resolveDerivedField(FieldName name) {
        DerivedField derivedField = this.getLocalDerivedField(name);
        if (derivedField == null) {
            return this.getDerivedField(name);
        }
        return derivedField;
    }

    @Override
    public Target getTarget(FieldName name) {
        M model = this.getModel();
        Targets targets = model.getTargets();
        if (targets == null) {
            return null;
        }
        for (Target target : targets) {
            if (!target.getField().equals((Object)name)) continue;
            return target;
        }
        return null;
    }

    @Override
    public List<FieldName> getOutputFields() {
        M model = this.getModel();
        Output output = model.getOutput();
        if (output == null) {
            return Collections.emptyList();
        }
        ArrayList<FieldName> result = new ArrayList<FieldName>();
        List outputFields = output.getOutputFields();
        for (OutputField outputField : outputFields) {
            result.add(outputField.getName());
        }
        return result;
    }

    @Override
    public OutputField getOutputField(FieldName name) {
        M model = this.getModel();
        Output output = model.getOutput();
        if (output == null) {
            return null;
        }
        return (OutputField)ModelManager.find(output.getOutputFields(), name);
    }

    public M getModel() {
        return this.model;
    }

    private void setModel(M model) {
        this.model = model;
    }
}

