/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Collection;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.Indexable;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.TransformationDictionary;
import org.jpmml.evaluator.InvalidFeatureException;

public class PMMLManager
implements Serializable {
    private PMML pmml = null;

    public PMMLManager(PMML pmml) {
        this.setPMML((PMML)Preconditions.checkNotNull((Object)pmml));
        DataDictionary dataDictionary = pmml.getDataDictionary();
        if (dataDictionary == null) {
            throw new InvalidFeatureException((PMMLObject)pmml);
        }
    }

    public DataField getDataField(FieldName name) {
        PMML pmml = this.getPMML();
        DataDictionary dataDictionary = pmml.getDataDictionary();
        return (DataField)PMMLManager.find(dataDictionary.getDataFields(), name);
    }

    public DerivedField getDerivedField(FieldName name) {
        PMML pmml = this.getPMML();
        TransformationDictionary transformationDictionary = pmml.getTransformationDictionary();
        if (transformationDictionary == null || !transformationDictionary.hasDerivedFields()) {
            return null;
        }
        return (DerivedField)PMMLManager.find(transformationDictionary.getDerivedFields(), name);
    }

    public DefineFunction getFunction(String name) {
        PMML pmml = this.getPMML();
        TransformationDictionary transformationDictionary = pmml.getTransformationDictionary();
        if (transformationDictionary == null || !transformationDictionary.hasDefineFunctions()) {
            return null;
        }
        return (DefineFunction)PMMLManager.find(transformationDictionary.getDefineFunctions(), name);
    }

    public PMML getPMML() {
        return this.pmml;
    }

    private void setPMML(PMML pmml) {
        this.pmml = pmml;
    }

    static <K, E extends Indexable<K>> E find(Collection<? extends E> elements, K key) {
        for (Indexable element : elements) {
            if (!element.getKey().equals(key)) continue;
            return (E)element;
        }
        return null;
    }
}

