/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.dmg.pmml.CompoundRule;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.MiningFunctionType;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.Rule;
import org.dmg.pmml.RuleSelectionMethod;
import org.dmg.pmml.RuleSet;
import org.dmg.pmml.RuleSetModel;
import org.dmg.pmml.SimpleRule;
import org.jpmml.evaluator.Classification;
import org.jpmml.evaluator.EntityUtil;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.HasEntityRegistry;
import org.jpmml.evaluator.InvalidFeatureException;
import org.jpmml.evaluator.InvalidResultException;
import org.jpmml.evaluator.ModelEvaluationContext;
import org.jpmml.evaluator.ModelEvaluator;
import org.jpmml.evaluator.OutputUtil;
import org.jpmml.evaluator.PredicateUtil;
import org.jpmml.evaluator.SimpleRuleScoreDistribution;
import org.jpmml.evaluator.TargetUtil;
import org.jpmml.evaluator.UnsupportedFeatureException;

public class RuleSetModelEvaluator
extends ModelEvaluator<RuleSetModel>
implements HasEntityRegistry<SimpleRule> {
    private static final LoadingCache<RuleSetModel, BiMap<String, SimpleRule>> entityCache = CacheBuilder.newBuilder().weakKeys().build((CacheLoader)new CacheLoader<RuleSetModel, BiMap<String, SimpleRule>>(){

        public BiMap<String, SimpleRule> load(RuleSetModel ruleSetModel) {
            ImmutableBiMap.Builder<String, SimpleRule> builder = new ImmutableBiMap.Builder<String, SimpleRule>();
            RuleSet ruleSet = ruleSetModel.getRuleSet();
            builder = this.collectRules(ruleSet.getRules(), new AtomicInteger(1), builder);
            return builder.build();
        }

        private ImmutableBiMap.Builder<String, SimpleRule> collectRule(Rule rule, AtomicInteger index, ImmutableBiMap.Builder<String, SimpleRule> builder) {
            if (rule instanceof SimpleRule) {
                SimpleRule simpleRule = (SimpleRule)rule;
                builder = EntityUtil.put(simpleRule, index, builder);
            } else if (rule instanceof CompoundRule) {
                CompoundRule compoundRule = (CompoundRule)rule;
                builder = this.collectRules(compoundRule.getRules(), index, builder);
            } else {
                throw new UnsupportedFeatureException((PMMLObject)rule);
            }
            return builder;
        }

        private ImmutableBiMap.Builder<String, SimpleRule> collectRules(List<Rule> rules, AtomicInteger index, ImmutableBiMap.Builder<String, SimpleRule> builder) {
            for (Rule rule : rules) {
                builder = this.collectRule(rule, index, builder);
            }
            return builder;
        }
    });

    public RuleSetModelEvaluator(PMML pmml) {
        super(pmml, RuleSetModel.class);
    }

    public RuleSetModelEvaluator(PMML pmml, RuleSetModel ruleSetModel) {
        super(pmml, ruleSetModel);
    }

    @Override
    public String getSummary() {
        return "Ruleset model";
    }

    @Override
    public BiMap<String, SimpleRule> getEntityRegistry() {
        return this.getValue(entityCache);
    }

    @Override
    public Map<FieldName, ?> evaluate(ModelEvaluationContext context) {
        Map<FieldName, ? extends Classification> predictions;
        RuleSetModel ruleSetModel = (RuleSetModel)this.getModel();
        if (!ruleSetModel.isScorable()) {
            throw new InvalidResultException((PMMLObject)ruleSetModel);
        }
        MiningFunctionType miningFunction = ruleSetModel.getFunctionName();
        switch (miningFunction) {
            case CLASSIFICATION: {
                predictions = this.evaluateClassification(context);
                break;
            }
            default: {
                throw new UnsupportedFeatureException((PMMLObject)ruleSetModel, (Enum<?>)miningFunction);
            }
        }
        return OutputUtil.evaluate(predictions, context);
    }

    private Map<FieldName, ? extends Classification> evaluateClassification(ModelEvaluationContext context) {
        RuleSetModel ruleSetModel = (RuleSetModel)this.getModel();
        RuleSet ruleSet = ruleSetModel.getRuleSet();
        List ruleSelectionMethods = ruleSet.getRuleSelectionMethods();
        if (ruleSelectionMethods.size() < 1) {
            throw new InvalidFeatureException((PMMLObject)ruleSet);
        }
        RuleSelectionMethod ruleSelectionMethod = (RuleSelectionMethod)ruleSelectionMethods.get(0);
        LinkedListMultimap firedRules = LinkedListMultimap.create();
        RuleSetModelEvaluator.evaluateRules(ruleSet.getRules(), (ListMultimap<String, SimpleRule>)firedRules, context);
        BiMap<String, SimpleRule> entityRegistry = this.getEntityRegistry();
        SimpleRuleScoreDistribution result = new SimpleRuleScoreDistribution(entityRegistry);
        if (firedRules.size() == 0) {
            String score = ruleSet.getDefaultScore();
            result.put(new SimpleRule(score), score, ruleSet.getDefaultConfidence());
            return TargetUtil.evaluateClassification(result, context);
        }
        RuleSelectionMethod.Criterion criterion = ruleSelectionMethod.getCriterion();
        Set keys = firedRules.keySet();
        block5: for (String key : keys) {
            List keyRules = firedRules.get((Object)key);
            switch (criterion) {
                case FIRST_HIT: {
                    SimpleRule winner = (SimpleRule)keyRules.get(0);
                    if (result.getEntity() == null) {
                        result.setEntity(winner);
                    }
                    result.put(key, winner.getConfidence());
                    continue block5;
                }
                case WEIGHTED_SUM: {
                    SimpleRule winner = null;
                    double totalWeight = 0.0;
                    for (SimpleRule keyRule : keyRules) {
                        if (winner == null || winner.getWeight() < keyRule.getWeight()) {
                            winner = keyRule;
                        }
                        totalWeight += keyRule.getWeight();
                    }
                    result.put(winner, key, totalWeight / (double)firedRules.size());
                    continue block5;
                }
                case WEIGHTED_MAX: {
                    SimpleRule winner = null;
                    for (SimpleRule keyRule : keyRules) {
                        if (winner != null && !(winner.getWeight() < keyRule.getWeight())) continue;
                        winner = keyRule;
                    }
                    result.put(winner, key, winner.getConfidence());
                    continue block5;
                }
            }
            throw new UnsupportedFeatureException((PMMLObject)ruleSelectionMethod, (Enum<?>)criterion);
        }
        return TargetUtil.evaluateClassification(result, context);
    }

    private static void evaluateRule(Rule rule, ListMultimap<String, SimpleRule> firedRules, EvaluationContext context) {
        Predicate predicate = rule.getPredicate();
        if (predicate == null) {
            throw new InvalidFeatureException((PMMLObject)rule);
        }
        Boolean status = PredicateUtil.evaluate(predicate, context);
        if (status == null || !status.booleanValue()) {
            return;
        }
        if (rule instanceof SimpleRule) {
            SimpleRule simpleRule = (SimpleRule)rule;
            firedRules.put((Object)simpleRule.getScore(), (Object)simpleRule);
        } else if (rule instanceof CompoundRule) {
            CompoundRule compoundRule = (CompoundRule)rule;
            RuleSetModelEvaluator.evaluateRules(compoundRule.getRules(), firedRules, context);
        } else {
            throw new UnsupportedFeatureException((PMMLObject)rule);
        }
    }

    private static void evaluateRules(List<Rule> rules, ListMultimap<String, SimpleRule> firedRules, EvaluationContext context) {
        for (Rule rule : rules) {
            RuleSetModelEvaluator.evaluateRule(rule, firedRules, context);
        }
    }
}

