/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSortedMap;
import java.util.AbstractList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.dmg.pmml.IntSparseArray;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.RealSparseArray;
import org.dmg.pmml.SparseArray;
import org.jpmml.evaluator.CacheUtil;
import org.jpmml.evaluator.InvalidFeatureException;
import org.jpmml.evaluator.UnsupportedFeatureException;

public class SparseArrayUtil {
    private static final LoadingCache<SparseArray<? extends Number>, SortedMap<Integer, ? extends Number>> contentCache = CacheBuilder.newBuilder().weakKeys().build((CacheLoader)new CacheLoader<SparseArray<? extends Number>, SortedMap<Integer, ? extends Number>>(){

        public SortedMap<Integer, ? extends Number> load(SparseArray<?> sparseArray) {
            return ImmutableSortedMap.copyOf(SparseArrayUtil.parse(sparseArray));
        }
    });

    private SparseArrayUtil() {
    }

    public static <E extends Number> SortedMap<Integer, E> getContent(SparseArray<E> sparseArray) {
        return CacheUtil.getValue(sparseArray, contentCache);
    }

    public static <E extends Number> List<E> asNumberList(SparseArray<E> sparseArray) {
        Number defaultValue;
        final SortedMap<Integer, E> content = SparseArrayUtil.getContent(sparseArray);
        Integer n = sparseArray.getN();
        final int size = n != null ? n.intValue() : content.size();
        if (sparseArray instanceof IntSparseArray) {
            IntSparseArray intSparseArray = (IntSparseArray)sparseArray;
            defaultValue = intSparseArray.getDefaultValue();
        } else if (sparseArray instanceof RealSparseArray) {
            RealSparseArray realSparseArray = (RealSparseArray)sparseArray;
            defaultValue = realSparseArray.getDefaultValue();
        } else {
            throw new UnsupportedFeatureException((PMMLObject)sparseArray);
        }
        AbstractList result = new AbstractList<E>(){

            @Override
            public int size() {
                return size;
            }

            @Override
            public E get(int index) {
                Number value = (Number)content.get(index + 1);
                if (value == null) {
                    value = defaultValue;
                }
                return value;
            }
        };
        return result;
    }

    public static <E extends Number> SortedMap<Integer, E> parse(SparseArray<E> sparseArray) {
        TreeMap<Integer, Number> result = new TreeMap<Integer, Number>();
        List indices = sparseArray.getIndices();
        List entries = sparseArray.getEntries();
        if (indices.size() != entries.size()) {
            throw new InvalidFeatureException((PMMLObject)sparseArray);
        }
        Integer n = sparseArray.getN();
        for (int i = 0; i < indices.size(); ++i) {
            Integer index = (Integer)indices.get(i);
            Number entry = (Number)entries.get(i);
            if (index < 1 || n != null && index > n) {
                throw new InvalidFeatureException((PMMLObject)sparseArray);
            }
            result.put(index, entry);
        }
        if (n != null && n < result.size()) {
            throw new InvalidFeatureException((PMMLObject)sparseArray);
        }
        return result;
    }
}

