/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.functions;

import com.google.common.base.Preconditions;
import java.util.List;
import org.dmg.pmml.DataType;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.Function;
import org.jpmml.evaluator.FunctionException;

public abstract class AbstractFunction
implements Function {
    private String name = null;

    public AbstractFunction(String name) {
        this.setName((String)Preconditions.checkNotNull((Object)name));
    }

    protected void checkArguments(List<FieldValue> arguments, int size) {
        this.checkArguments(arguments, size, false);
    }

    protected void checkArguments(List<FieldValue> arguments, int size, boolean allowNulls) {
        if (arguments.size() != size) {
            throw new FunctionException(this, "Expected " + size + " arguments, but got " + arguments.size() + " arguments");
        }
        if (!allowNulls && arguments.contains(null)) {
            throw new FunctionException(this, "Missing arguments");
        }
    }

    protected void checkVariableArguments(List<FieldValue> arguments, int minSize) {
        this.checkVariableArguments(arguments, minSize, false);
    }

    protected void checkVariableArguments(List<FieldValue> arguments, int minSize, boolean allowNulls) {
        if (arguments.size() < minSize) {
            throw new FunctionException(this, "Expected " + minSize + " or more arguments, but got " + arguments.size() + " arguments");
        }
        if (!allowNulls && arguments.contains(null)) {
            throw new FunctionException(this, "Missing arguments");
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    private void setName(String name) {
        this.name = name;
    }

    protected static Number cast(DataType dataType, Number number) {
        switch (dataType) {
            case INTEGER: {
                if (number instanceof Integer) {
                    return number;
                }
                return number.intValue();
            }
            case FLOAT: {
                if (number instanceof Float) {
                    return number;
                }
                return Float.valueOf(number.floatValue());
            }
            case DOUBLE: {
                if (number instanceof Double) {
                    return number;
                }
                return number.doubleValue();
            }
        }
        throw new EvaluationException();
    }

    protected static DataType integerToDouble(DataType dataType) {
        switch (dataType) {
            case INTEGER: {
                return DataType.DOUBLE;
            }
        }
        return dataType;
    }
}

