/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.dmg.pmml.PMMLObject;
import org.jpmml.evaluator.InvalidFeatureException;
import org.jpmml.evaluator.PMMLException;

public class CacheUtil {
    private CacheUtil() {
    }

    public static <K extends PMMLObject, V> V getValue(K key, LoadingCache<K, V> cache) {
        try {
            return (V)cache.get(key);
        }
        catch (ExecutionException ee) {
            throw new InvalidFeatureException(key);
        }
        catch (UncheckedExecutionException uee) {
            Throwable cause = uee.getCause();
            if (cause instanceof PMMLException) {
                throw (PMMLException)cause;
            }
            throw new InvalidFeatureException(key);
        }
    }

    public static <K extends PMMLObject, V> V getValue(K key, Callable<? extends V> loader, Cache<K, V> cache) {
        try {
            return (V)cache.get(key, loader);
        }
        catch (ExecutionException ee) {
            throw new InvalidFeatureException(key);
        }
        catch (UncheckedExecutionException uee) {
            Throwable cause = uee.getCause();
            if (cause instanceof PMMLException) {
                throw (PMMLException)cause;
            }
            throw new InvalidFeatureException(key);
        }
    }

    public static <K extends PMMLObject, V> Cache<K, V> buildCache() {
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder().weakKeys();
        return cacheBuilder.build();
    }

    public static <K extends PMMLObject, V> LoadingCache<K, V> buildLoadingCache(CacheLoader<K, V> cacheLoader) {
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder().weakKeys();
        return cacheBuilder.build(cacheLoader);
    }
}

