/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.Function;
import org.jpmml.evaluator.TypeCheckException;

public class FunctionRegistry {
    private static final Map<String, Function> functions = new LinkedHashMap<String, Function>();

    private FunctionRegistry() {
    }

    public static Function getFunction(String name) {
        Function function = functions.get(name);
        if (function == null) {
            function = FunctionRegistry.loadJavaFunction(name);
        }
        return function;
    }

    public static void putFunction(Function function) {
        FunctionRegistry.putFunction(function.getName(), function);
    }

    public static void putFunction(String name, Function function) {
        functions.put(Objects.requireNonNull(name), function);
    }

    public static Function removeFunction(String name) {
        return functions.remove(name);
    }

    private static Function loadJavaFunction(String name) {
        Function function;
        Class<?> clazz;
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                classLoader = FunctionRegistry.class.getClassLoader();
            }
            clazz = classLoader.loadClass(name);
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
        if (!Function.class.isAssignableFrom(clazz)) {
            throw new TypeCheckException(Function.class, clazz);
        }
        try {
            function = (Function)clazz.newInstance();
        }
        catch (Exception e) {
            throw new EvaluationException();
        }
        return function;
    }
}

