/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.Apply;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.ParameterField;
import org.jpmml.evaluator.DefineFunctionEvaluationContext;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.ExpressionUtil;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.Function;
import org.jpmml.evaluator.FunctionRegistry;
import org.jpmml.evaluator.Functions;
import org.jpmml.evaluator.InvalidFeatureException;
import org.jpmml.evaluator.UnsupportedFeatureException;
import org.jpmml.evaluator.functions.AbstractFunction;
import org.jpmml.model.ReflectionUtil;

public class FunctionUtil {
    private static final Map<String, Function> builtInFunctions;

    private FunctionUtil() {
    }

    public static FieldValue evaluate(Apply apply, List<FieldValue> values, EvaluationContext context) {
        String name = apply.getFunction();
        if (name == null) {
            throw new InvalidFeatureException((PMMLObject)apply);
        }
        Function builtInFunction = FunctionUtil.getFunction(name);
        if (builtInFunction != null) {
            return builtInFunction.evaluate(values);
        }
        Function userDefinedFunction = FunctionRegistry.getFunction(name);
        if (userDefinedFunction != null) {
            return userDefinedFunction.evaluate(values);
        }
        EvaluationContext.Result<DefineFunction> result = context.resolveFunction(name);
        if (result != null) {
            return FunctionUtil.evaluate(result.getElement(), values, context);
        }
        throw new UnsupportedFeatureException((PMMLObject)apply, ReflectionUtil.getField((Object)apply, (String)"function"), name);
    }

    public static FieldValue evaluate(DefineFunction defineFunction, List<FieldValue> values, EvaluationContext context) {
        List parameterFields = defineFunction.getParameterFields();
        if (parameterFields.size() < 1) {
            throw new InvalidFeatureException((PMMLObject)defineFunction);
        }
        if (parameterFields.size() != values.size()) {
            throw new EvaluationException();
        }
        DefineFunctionEvaluationContext functionContext = new DefineFunctionEvaluationContext(context);
        for (int i = 0; i < parameterFields.size(); ++i) {
            ParameterField parameterField = (ParameterField)parameterFields.get(i);
            FieldValue value = FieldValueUtil.refine((Field)parameterField, values.get(i));
            functionContext.declare(parameterField.getName(), value);
        }
        Expression expression = defineFunction.getExpression();
        if (expression == null) {
            throw new InvalidFeatureException((PMMLObject)defineFunction);
        }
        FieldValue result = ExpressionUtil.evaluate(expression, (EvaluationContext)functionContext);
        return FieldValueUtil.refine(defineFunction.getDataType(), defineFunction.getOpType(), result);
    }

    public static Function getFunction(String name) {
        return builtInFunctions.get(name);
    }

    static {
        List<AbstractFunction> functions = Arrays.asList(Functions.PLUS, Functions.MINUS, Functions.MULTIPLY, Functions.DIVIDE, Functions.MIN, Functions.MAX, Functions.AVG, Functions.SUM, Functions.PRODUCT, Functions.LOG10, Functions.LN, Functions.EXP, Functions.SQRT, Functions.ABS, Functions.POW, Functions.THRESHOLD, Functions.FLOOR, Functions.CEIL, Functions.ROUND, Functions.IS_MISSING, Functions.IS_NOT_MISSING, Functions.EQUAL, Functions.NOT_EQUAL, Functions.LESS_THAN, Functions.LESS_OR_EQUAL, Functions.GREATER_THAN, Functions.GREATER_OR_EQUAL, Functions.AND, Functions.OR, Functions.NOT, Functions.IS_IN, Functions.IS_NOT_IN, Functions.IF, Functions.UPPERCASE, Functions.LOWERCASE, Functions.SUBSTRING, Functions.TRIM_BLANKS, Functions.CONCAT, Functions.REPLACE, Functions.MATCHES, Functions.FORMAT_NUMBER, Functions.FORMAT_DATETIME, Functions.DATE_DAYS_SINCE_YEAR, Functions.DATE_SECONDS_SINCE_MIDNIGHT, Functions.DATE_SECONDS_SINCE_YEAR);
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (Function function : functions) {
            builder.put((Object)function.getName(), (Object)function);
        }
        builtInFunctions = builder.build();
    }
}

