/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.List;
import org.dmg.pmml.LinearNorm;
import org.dmg.pmml.NormContinuous;
import org.dmg.pmml.OutlierTreatmentMethodType;
import org.dmg.pmml.PMMLObject;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.InvalidFeatureException;
import org.jpmml.evaluator.UnsupportedFeatureException;

public class NormalizationUtil {
    private NormalizationUtil() {
    }

    public static FieldValue normalize(NormContinuous normContinuous, FieldValue value) {
        double result = NormalizationUtil.normalize(normContinuous, value.asNumber().doubleValue());
        return FieldValueUtil.create(result);
    }

    public static double normalize(NormContinuous normContinuous, double value) {
        List linearNorms = normContinuous.getLinearNorms();
        if (linearNorms.size() < 2) {
            throw new InvalidFeatureException((PMMLObject)normContinuous);
        }
        LinearNorm rangeStart = (LinearNorm)linearNorms.get(0);
        LinearNorm rangeEnd = (LinearNorm)linearNorms.get(linearNorms.size() - 1);
        if (value >= rangeStart.getOrig() && value <= rangeEnd.getOrig()) {
            for (int i = 1; i < linearNorms.size() - 1; ++i) {
                LinearNorm linearNorm = (LinearNorm)linearNorms.get(i);
                if (value >= linearNorm.getOrig()) {
                    rangeStart = linearNorm;
                    continue;
                }
                if (!(value <= linearNorm.getOrig())) continue;
                rangeEnd = linearNorm;
                break;
            }
        } else {
            OutlierTreatmentMethodType outlierTreatmentMethod = normContinuous.getOutliers();
            switch (outlierTreatmentMethod) {
                case AS_MISSING_VALUES: {
                    Double missing = normContinuous.getMapMissingTo();
                    if (missing == null) {
                        throw new InvalidFeatureException((PMMLObject)normContinuous);
                    }
                    return missing;
                }
                case AS_IS: {
                    if (value < rangeStart.getOrig()) {
                        rangeEnd = (LinearNorm)linearNorms.get(1);
                        break;
                    }
                    rangeStart = (LinearNorm)linearNorms.get(linearNorms.size() - 2);
                    break;
                }
                case AS_EXTREME_VALUES: {
                    if (value < rangeStart.getOrig()) {
                        return rangeStart.getNorm();
                    }
                    return rangeEnd.getNorm();
                }
                default: {
                    throw new UnsupportedFeatureException((PMMLObject)normContinuous, (Enum<?>)outlierTreatmentMethod);
                }
            }
        }
        double origRange = rangeEnd.getOrig() - rangeStart.getOrig();
        double normRange = rangeEnd.getNorm() - rangeStart.getNorm();
        return rangeStart.getNorm() + (value - rangeStart.getOrig()) / origRange * normRange;
    }

    public static double denormalize(NormContinuous normContinuous, double value) {
        List linearNorms = normContinuous.getLinearNorms();
        if (linearNorms.size() < 2) {
            throw new InvalidFeatureException((PMMLObject)normContinuous);
        }
        LinearNorm rangeStart = (LinearNorm)linearNorms.get(0);
        LinearNorm rangeEnd = (LinearNorm)linearNorms.get(linearNorms.size() - 1);
        for (int i = 1; i < linearNorms.size() - 1; ++i) {
            LinearNorm linearNorm = (LinearNorm)linearNorms.get(i);
            if (value >= linearNorm.getNorm()) {
                rangeStart = linearNorm;
                continue;
            }
            if (!(value <= linearNorm.getNorm())) continue;
            rangeEnd = linearNorm;
            break;
        }
        double origRange = rangeEnd.getOrig() - rangeStart.getOrig();
        double normRange = rangeEnd.getNorm() - rangeStart.getNorm();
        return (value - rangeStart.getNorm()) / normRange * origRange + rangeStart.getOrig();
    }
}

