/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.io.Serializable;
import java.util.Objects;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.TransformationDictionary;
import org.jpmml.evaluator.IndexableUtil;
import org.jpmml.evaluator.InvalidFeatureException;

public class PMMLManager
implements Serializable {
    private PMML pmml = null;

    public PMMLManager(PMML pmml) {
        this.setPMML(Objects.requireNonNull(pmml));
        DataDictionary dataDictionary = pmml.getDataDictionary();
        if (dataDictionary == null) {
            throw new InvalidFeatureException((PMMLObject)pmml);
        }
    }

    public DataField getDataField(FieldName name) {
        PMML pmml = this.getPMML();
        DataDictionary dataDictionary = pmml.getDataDictionary();
        return (DataField)IndexableUtil.find(dataDictionary.getDataFields(), name);
    }

    public DerivedField getDerivedField(FieldName name) {
        PMML pmml = this.getPMML();
        TransformationDictionary transformationDictionary = pmml.getTransformationDictionary();
        if (transformationDictionary != null && transformationDictionary.hasDerivedFields()) {
            return (DerivedField)IndexableUtil.find(transformationDictionary.getDerivedFields(), name);
        }
        return null;
    }

    public DefineFunction getFunction(String name) {
        PMML pmml = this.getPMML();
        TransformationDictionary transformationDictionary = pmml.getTransformationDictionary();
        if (transformationDictionary != null && transformationDictionary.hasDefineFunctions()) {
            return (DefineFunction)IndexableUtil.find(transformationDictionary.getDefineFunctions(), name);
        }
        return null;
    }

    public PMML getPMML() {
        return this.pmml;
    }

    private void setPMML(PMML pmml) {
        this.pmml = pmml;
    }
}

